/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.widget;

import dev.tr7zw.trender.gui.GuiDescription;
import dev.tr7zw.trender.gui.client.RenderContext;
import dev.tr7zw.trender.gui.impl.VisualLogger;
import dev.tr7zw.trender.gui.widget.TooltipBuilder;
import dev.tr7zw.trender.gui.widget.WPanel;
import dev.tr7zw.trender.gui.widget.data.InputResult;
import dev.tr7zw.trender.gui.widget.data.ObservableProperty;
import dev.tr7zw.trender.gui.widget.focus.FocusModel;
import lombok.Generated;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class WWidget {
    private static final VisualLogger LOGGER = new VisualLogger(WWidget.class);
    @Nullable
    private WPanel parent;
    protected int x = 0;
    protected int y = 0;
    private int width = 18;
    private int height = 18;
    @Nullable
    protected class_2561 tooltip;
    @Nullable
    private Runnable onRefresh;
    @Nullable
    protected GuiDescription host;
    private final ObservableProperty<Boolean> hovered = ObservableProperty.of(false).nonnull().name("WWidget.hovered").build();

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(int x, int y) {
        this.width = x;
        this.height = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getAbsoluteX() {
        if (this.parent == null) {
            return this.getX();
        }
        return this.getX() + this.parent.getAbsoluteX();
    }

    public int getAbsoluteY() {
        if (this.parent == null) {
            return this.getY();
        }
        return this.getY() + this.parent.getAbsoluteY();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean canResize() {
        return false;
    }

    @Nullable
    public WPanel getParent() {
        return this.parent;
    }

    public void setParent(WPanel parent) {
        this.parent = parent;
    }

    public InputResult onMouseDown(int x, int y, int button) {
        return InputResult.IGNORED;
    }

    public InputResult onMouseDrag(int x, int y, int button, double deltaX, double deltaY) {
        return InputResult.IGNORED;
    }

    public InputResult onMouseUp(int x, int y, int button) {
        return InputResult.IGNORED;
    }

    public InputResult onClick(int x, int y, int button) {
        return InputResult.IGNORED;
    }

    public InputResult onMouseScroll(int x, int y, double horizontalAmount, double verticalAmount) {
        return InputResult.IGNORED;
    }

    public InputResult onMouseMove(int x, int y) {
        return InputResult.IGNORED;
    }

    public InputResult onCharTyped(char ch) {
        return InputResult.IGNORED;
    }

    public InputResult onKeyPressed(int ch, int key, int modifiers) {
        return InputResult.IGNORED;
    }

    public InputResult onKeyReleased(int ch, int key, int modifiers) {
        return InputResult.IGNORED;
    }

    public void onFocusGained() {
    }

    public void onFocusLost() {
    }

    public boolean isFocused() {
        if (this.host == null) {
            return false;
        }
        return this.host.isFocused(this);
    }

    public void requestFocus() {
        if (this.host != null) {
            this.host.requestFocus(this);
        } else {
            LOGGER.warn("Requesting focus for {}, but the host is null", this);
        }
    }

    public void releaseFocus() {
        if (this.host != null) {
            this.host.releaseFocus(this);
        }
    }

    public boolean canFocus() {
        return false;
    }

    public void paint(RenderContext context, int x, int y, int mouseX, int mouseY) {
    }

    public boolean isWithinBounds(int x, int y) {
        return x >= 0 && y >= 0 && x < this.getWidth() && y < this.getHeight();
    }

    public void renderTooltip(RenderContext context, int x, int y, int tX, int tY) {
        TooltipBuilder builder = new TooltipBuilder();
        this.addTooltip(builder);
        if (builder.size() == 0) {
            return;
        }
        class_310 client = class_310.method_1551();
        context.renderTooltip(client.field_1772, builder.lines, tX + x, tY + y);
    }

    public void validate(GuiDescription host) {
        if (host != null) {
            this.host = host;
        } else {
            LOGGER.warn("Validating {} with a null host", this);
        }
    }

    @Nullable
    public final GuiDescription getHost() {
        return this.host;
    }

    public void setHost(GuiDescription host) {
        if (host != null) {
            this.host = host;
        } else {
            LOGGER.warn("Setting null host for {}", this);
        }
    }

    public void addTooltip(TooltipBuilder tooltipBuilder) {
        if (this.tooltip != null) {
            class_310.method_1551().field_1772.method_1728((class_5348)this.tooltip, 170).forEach(f -> tooltipBuilder.add((class_5481)f));
        }
    }

    public void setToolip(class_2561 tooltip) {
        this.tooltip = tooltip;
    }

    public WWidget hit(int x, int y) {
        return this;
    }

    public void refresh() {
        if (this.onRefresh != null) {
            this.onRefresh.run();
        }
    }

    public void tick() {
    }

    @Nullable
    public FocusModel<?> getFocusModel() {
        return this.canFocus() ? FocusModel.simple(this) : null;
    }

    public void onShown() {
    }

    public void onHidden() {
        this.releaseFocus();
    }

    public void addPainters() {
    }

    public boolean canHover() {
        return true;
    }

    public ObservableProperty<Boolean> hoveredProperty() {
        return this.hovered;
    }

    public final boolean isHovered() {
        return this.hoveredProperty().get();
    }

    public final void setHovered(boolean hovered) {
        this.hoveredProperty().set(hovered);
    }

    public boolean isNarratable() {
        return true;
    }

    public void addNarrations(class_6382 builder) {
    }

    public static boolean isActivationKey(int ch) {
        return ch == 257 || ch == 335 || ch == 32;
    }

    @Generated
    public void setOnRefresh(@Nullable Runnable onRefresh) {
        this.onRefresh = onRefresh;
    }
}

