/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.widget;

import dev.tr7zw.trender.gui.client.LibGui;
import dev.tr7zw.trender.gui.client.RenderContext;
import dev.tr7zw.trender.gui.client.ScreenDrawing;
import dev.tr7zw.trender.gui.impl.client.TextAlignment;
import dev.tr7zw.trender.gui.widget.WWidget;
import dev.tr7zw.trender.gui.widget.data.HorizontalAlignment;
import dev.tr7zw.trender.gui.widget.data.InputResult;
import dev.tr7zw.trender.gui.widget.data.VerticalAlignment;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class WText
extends WWidget {
    protected class_2561 text;
    protected int color;
    protected Boolean drawShadows;
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    protected VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
    private List<class_5481> wrappedLines;
    private boolean wrappingScheduled = false;

    public WText(class_2561 text) {
        this(text, -12566464);
    }

    public WText(class_2561 text, int color) {
        this.text = Objects.requireNonNull(text, "text must not be null");
        this.color = color;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, y);
        this.wrappingScheduled = true;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    private void wrapLines() {
        class_327 font = class_310.method_1551().field_1772;
        this.wrappedLines = font.method_1728((class_5348)this.text, this.getWidth());
    }

    @Nullable
    public class_2583 getTextStyleAt(int x, int y) {
        class_327 font = class_310.method_1551().field_1772;
        int yOffset = TextAlignment.getTextOffsetY(this.verticalAlignment, this.getHeight(), this.wrappedLines.size());
        Objects.requireNonNull(font);
        int lineIndex = (y - yOffset) / 9;
        if (lineIndex >= 0 && lineIndex < this.wrappedLines.size()) {
            class_5481 line = this.wrappedLines.get(lineIndex);
            int xOffset = TextAlignment.getTextOffsetX(this.horizontalAlignment, this.getWidth(), line);
            return font.method_27527().method_30876(line, x - xOffset);
        }
        return null;
    }

    @Override
    public void paint(RenderContext context, int x, int y, int mouseX, int mouseY) {
        if (this.wrappedLines == null || this.wrappingScheduled) {
            this.wrapLines();
            this.wrappingScheduled = false;
        }
        class_327 font = class_310.method_1551().field_1772;
        int yOffset = TextAlignment.getTextOffsetY(this.verticalAlignment, this.getHeight(), this.wrappedLines.size());
        for (int i = 0; i < this.wrappedLines.size(); ++i) {
            class_5481 line = this.wrappedLines.get(i);
            int c = this.color;
            if (this.getDrawShadows()) {
                Objects.requireNonNull(font);
                ScreenDrawing.drawStringWithShadow(context, line, this.horizontalAlignment, x, y + yOffset + i * 9, this.getWidth(), c);
                continue;
            }
            Objects.requireNonNull(font);
            ScreenDrawing.drawString(context, line, this.horizontalAlignment, x, y + yOffset + i * 9, this.getWidth(), c);
        }
        class_2583 hoveredTextStyle = this.getTextStyleAt(mouseX, mouseY);
        ScreenDrawing.drawTextHover(context, hoveredTextStyle, x + mouseX, y + mouseY);
    }

    @Override
    public InputResult onClick(int x, int y, int button) {
        if (button != 0) {
            return InputResult.IGNORED;
        }
        class_2583 hoveredTextStyle = this.getTextStyleAt(x, y);
        if (hoveredTextStyle != null) {
            boolean processed = class_310.method_1551().field_1755.method_25430(hoveredTextStyle);
            return InputResult.of(processed);
        }
        return InputResult.IGNORED;
    }

    public class_2561 getText() {
        return this.text;
    }

    public WText setText(class_2561 text) {
        Objects.requireNonNull(text, "text is null");
        this.text = text;
        this.wrappingScheduled = true;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public WText setColor(int color) {
        this.color = color;
        return this;
    }

    public boolean getDrawShadows() {
        return this.drawShadows == null ? LibGui.getGuiStyle().isFontShadow() : this.drawShadows.booleanValue();
    }

    public WText setDrawShadows(boolean drawShadows) {
        this.drawShadows = drawShadows;
        return this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public WText setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public WText setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @Override
    public void addNarrations(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, this.text);
    }
}

