/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.widget;

import dev.tr7zw.trender.gui.GuiDescription;
import dev.tr7zw.trender.gui.client.BackgroundPainter;
import dev.tr7zw.trender.gui.impl.client.NarrationMessages;
import dev.tr7zw.trender.gui.widget.WItemSlot;
import dev.tr7zw.trender.gui.widget.WLabel;
import dev.tr7zw.trender.gui.widget.WPanel;
import dev.tr7zw.trender.gui.widget.WPlainPanel;
import dev.tr7zw.trender.gui.widget.WWidget;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class WPlayerInvPanel
extends WPlainPanel {
    protected final WItemSlot inventory;
    protected final WItemSlot hotbar;
    @Nullable
    protected final WWidget label;

    public WPlayerInvPanel(class_1661 playerInventory) {
        this(playerInventory, true);
    }

    public WPlayerInvPanel(class_1661 playerInventory, boolean hasLabel) {
        this(playerInventory, hasLabel ? WPlayerInvPanel.createInventoryLabel(playerInventory) : null);
    }

    public WPlayerInvPanel(class_1661 playerInventory, @Nullable WWidget label) {
        int y = 0;
        this.label = label;
        if (label != null) {
            this.add(label, 0, 0, label.getWidth(), label.getHeight());
            y += label.getHeight();
        }
        this.inventory = WItemSlot.ofPlayerStorage((class_1263)playerInventory);
        this.hotbar = new WItemSlot(this, (class_1263)playerInventory, 0, 9, 1, false){

            @Override
            protected class_2561 getNarrationName() {
                return NarrationMessages.Vanilla.HOTBAR;
            }
        };
        this.add(this.inventory, 0, y);
        this.add(this.hotbar, 0, y + 58);
    }

    @Override
    public boolean canResize() {
        return false;
    }

    public static WLabel createInventoryLabel(class_1661 playerInventory) {
        WLabel label = new WLabel(playerInventory.method_5476());
        label.setSize(162, 11);
        return label;
    }

    @Override
    public WPanel setBackgroundPainter(BackgroundPainter painter) {
        super.setBackgroundPainter(null);
        this.inventory.setBackgroundPainter(painter);
        this.hotbar.setBackgroundPainter(painter);
        return this;
    }

    @Override
    public void validate(GuiDescription c) {
        WWidget wWidget;
        super.validate(c);
        if (c != null && (wWidget = this.label) instanceof WLabel) {
            WLabel l = (WLabel)wWidget;
            l.setColor(c.getTitleColor());
        }
    }
}

