/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.widget;

import dev.tr7zw.trender.gui.GuiDescription;
import dev.tr7zw.trender.gui.client.RenderContext;
import dev.tr7zw.trender.gui.impl.Proxy;
import dev.tr7zw.trender.gui.widget.WClippedPanel;
import dev.tr7zw.trender.gui.widget.WPanel;
import dev.tr7zw.trender.gui.widget.WScrollBar;
import dev.tr7zw.trender.gui.widget.WWidget;
import dev.tr7zw.trender.gui.widget.data.Axis;
import dev.tr7zw.trender.gui.widget.data.InputResult;
import dev.tr7zw.trender.gui.widget.data.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;

public class WListPanel<D, W extends WWidget>
extends WClippedPanel {
    protected List<D> data;
    protected Supplier<W> supplier;
    protected BiConsumer<D, W> configurator;
    protected HashMap<D, W> configured = new HashMap();
    protected List<W> unconfigured = new ArrayList<W>();
    protected int cellHeight = 20;
    protected boolean fixedHeight = false;
    private Insets insets = new Insets(4, 4);
    private int gap = 4;
    protected WScrollBar scrollBar = new WScrollBar(Axis.VERTICAL);
    private int lastScroll = -1;
    private final List<W> requiresHost = new ArrayList<W>();
    private Predicate<D> filter = v -> true;

    public WListPanel(List<D> data, Supplier<W> supplier, BiConsumer<D, W> configurator) {
        this.data = data;
        this.supplier = supplier;
        this.configurator = configurator;
        this.scrollBar.setMaxValue(data.size());
        this.scrollBar.setParent(this);
    }

    @Override
    public void paint(RenderContext context, int x, int y, int mouseX, int mouseY) {
        if (this.scrollBar.getValue() != this.lastScroll) {
            this.layout();
            this.lastScroll = this.scrollBar.getValue();
        }
        super.paint(context, x, y, mouseX, mouseY);
    }

    private W createChild() {
        WWidget child = (WWidget)this.supplier.get();
        child.setParent(this);
        if (this.host != null) {
            child.setHost(this.host);
        } else {
            this.requiresHost.add(child);
        }
        Proxy.proxy.addPainters(child);
        return (W)child;
    }

    @Override
    public void validate(GuiDescription c) {
        super.validate(c);
        this.setRequiredHosts(c);
    }

    @Override
    public void setHost(GuiDescription host) {
        super.setHost(host);
        this.setRequiredHosts(host);
    }

    @Override
    public void addPainters() {
    }

    private void setRequiredHosts(GuiDescription host) {
        for (WWidget widget : this.requiresHost) {
            widget.setHost(host);
        }
        this.requiresHost.clear();
    }

    @Override
    public void layout() {
        this.children.clear();
        this.children.add(this.scrollBar);
        this.scrollBar.setLocation(this.getWidth() - this.scrollBar.getWidth(), 0);
        this.scrollBar.setSize(8, this.getHeight());
        if (!this.fixedHeight) {
            if (this.unconfigured.isEmpty()) {
                if (this.configured.isEmpty()) {
                    exemplar = this.createChild();
                    this.unconfigured.add(exemplar);
                    if (!exemplar.canResize()) {
                        this.cellHeight = exemplar.getHeight();
                    }
                } else {
                    exemplar = (WWidget)this.configured.values().iterator().next();
                    if (!exemplar.canResize()) {
                        this.cellHeight = exemplar.getHeight();
                    }
                }
            } else {
                exemplar = (WWidget)this.unconfigured.get(0);
                if (!exemplar.canResize()) {
                    this.cellHeight = exemplar.getHeight();
                }
            }
        }
        if (this.cellHeight < 4) {
            this.cellHeight = 4;
        }
        Insets insets = this.getInsets();
        int gap = this.getGap();
        int layoutHeight = this.getHeight() - insets.height();
        int cellsHigh = Math.max((layoutHeight + gap) / (this.cellHeight + gap), 1);
        ArrayList<D> filteredData = new ArrayList<D>(this.data);
        filteredData.removeIf(this.filter.negate());
        this.scrollBar.setWindow(cellsHigh);
        this.scrollBar.setMaxValue(filteredData.size());
        int scrollOffset = this.scrollBar.getValue();
        int presentCells = Math.min(filteredData.size() - scrollOffset, cellsHigh);
        if (presentCells > 0) {
            int index;
            for (int i = 0; i < presentCells && (index = i + scrollOffset) < filteredData.size(); ++i) {
                if (index < 0) continue;
                Object d = filteredData.get(index);
                WWidget w = (WWidget)this.configured.get(d);
                if (w == null) {
                    w = this.unconfigured.isEmpty() ? this.createChild() : (WWidget)this.unconfigured.remove(0);
                    this.configurator.accept(d, w);
                    this.configured.put(d, w);
                }
                if (w.canResize()) {
                    w.setSize(this.getWidth() - insets.width() - this.scrollBar.getWidth(), this.cellHeight);
                }
                if (w instanceof WPanel) {
                    WPanel panel = (WPanel)w;
                    panel.layout();
                }
                w.refresh();
                w.x = insets.left();
                w.y = insets.top() + (this.cellHeight + gap) * i;
                this.children.add(w);
            }
        }
    }

    public WListPanel<D, W> setListItemHeight(int height) {
        this.cellHeight = height;
        this.fixedHeight = true;
        return this;
    }

    @Override
    public InputResult onMouseScroll(int x, int y, double horizontalAmount, double verticalAmount) {
        return this.scrollBar.onMouseScroll(0, 0, horizontalAmount, verticalAmount);
    }

    public WScrollBar getScrollBar() {
        return this.scrollBar;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public WListPanel<D, W> setInsets(Insets insets) {
        this.insets = Objects.requireNonNull(insets, "Insets cannot be null");
        return this;
    }

    public int getGap() {
        return this.gap;
    }

    public WListPanel<D, W> setGap(int gap) {
        this.gap = gap;
        return this;
    }

    @Generated
    public void setFilter(Predicate<D> filter) {
        this.filter = filter;
    }
}

