/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.client;

import dev.tr7zw.trender.gui.client.LibGui;
import dev.tr7zw.trender.gui.client.RenderContext;
import dev.tr7zw.trender.gui.client.Scissors;
import dev.tr7zw.trender.gui.widget.data.HorizontalAlignment;
import dev.tr7zw.trender.gui.widget.data.Texture;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class ScreenDrawing {
    private ScreenDrawing() {
    }

    public static void texturedRect(RenderContext context, int x, int y, int width, int height, class_2960 texture, float u1, float v1, float u2, float v2, int color) {
        ScreenDrawing.texturedRect(context, x, y, width, height, texture, u1, v1, u2, v2, color, 1.0f, 64, 64);
    }

    public static void texturedRect(RenderContext context, int x, int y, int width, int height, class_2960 texture, float u1, float v1, float u2, float v2, int color, int textureWidth, int textureHeight) {
        ScreenDrawing.texturedRect(context, x, y, width, height, texture, u1, v1, u2, v2, color, 1.0f, textureWidth, textureHeight);
    }

    public static void texturedRect(RenderContext context, int x, int y, int width, int height, Texture texture, int color, int textureWidth, int textureHeight) {
        ScreenDrawing.texturedRect(context, x, y, width, height, texture, color, 1.0f, textureWidth, textureHeight);
    }

    public static void texturedRect(RenderContext context, int x, int y, int width, int height, Texture texture, int color) {
        ScreenDrawing.texturedRect(context, x, y, width, height, texture, color, 1.0f, 64, 64);
    }

    public static void texturedRect(RenderContext context, int x, int y, int width, int height, Texture texture, int color, float opacity, int textureWidth, int textureHeight) {
        switch (texture.type()) {
            case STANDALONE: {
                ScreenDrawing.texturedRect(context, x, y, width, height, texture.image(), texture.u1(), texture.v1(), texture.u2(), texture.v2(), color, opacity, textureWidth, textureHeight);
                break;
            }
            case GUI_SPRITE: {
                if (texture.u1() == 0.0f && texture.u2() == 1.0f && texture.v1() == 0.0f && texture.v2() == 1.0f) {
                    context.blitSprite(texture.image(), x, y, width, height, color);
                    break;
                }
                float fullWidth = (float)width / Math.abs(texture.u2() - texture.u1());
                float fullHeight = (float)height / Math.abs(texture.v2() - texture.v1());
                if (Float.isInfinite(fullWidth) || Float.isInfinite(fullHeight)) break;
                float xo = (float)x - fullWidth * Math.min(texture.u1(), texture.u2());
                float yo = (float)y - fullHeight * Math.min(texture.v1(), texture.v2());
                context.pushPose();
                context.translate(xo, yo);
                context.scale(fullWidth / (float)width, fullHeight / (float)height);
                try (Scissors.Frame frame = Scissors.push(context, x, y, width, height);){
                    context.blitSprite(texture.image(), 0, 0, width, height, color);
                }
                context.popPose();
            }
        }
    }

    public static void texturedRect(RenderContext context, int x, int y, int width, int height, class_2960 texture, float u1, float v1, float u2, float v2, int color, float opacity, int textureWidth, int textureHeight) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        color = ScreenDrawing.colorAtOpacity(color, a * opacity);
        context.blit(texture, x, y, (float)textureWidth * u1, (float)textureHeight * v1, width, height, textureWidth, textureHeight);
    }

    public static void coloredRect(RenderContext context, int left, int top, int width, int height, int color) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        context.fill(left, top, left + width, top + height, color);
    }

    public static void drawGuiPanel(RenderContext context, int x, int y, int width, int height) {
        if (LibGui.getGuiStyle().isDark()) {
            ScreenDrawing.drawGuiPanel(context, x, y, width, height, -16053493, -13684945, -12500671, -16777216);
        } else {
            ScreenDrawing.drawGuiPanel(context, x, y, width, height, -11184811, -3750202, -1, -16777216);
        }
    }

    public static void drawGuiPanel(RenderContext context, int x, int y, int width, int height, int panelColor) {
        int shadowColor = ScreenDrawing.multiplyColor(panelColor, 0.5f);
        int hilightColor = ScreenDrawing.multiplyColor(panelColor, 1.25f);
        ScreenDrawing.drawGuiPanel(context, x, y, width, height, shadowColor, panelColor, hilightColor, -16777216);
    }

    public static void drawGuiPanel(RenderContext context, int x, int y, int width, int height, int shadow, int panel, int hilight, int outline) {
        ScreenDrawing.coloredRect(context, x + 3, y + 3, width - 6, height - 6, panel);
        ScreenDrawing.coloredRect(context, x + 2, y + 1, width - 4, 2, hilight);
        ScreenDrawing.coloredRect(context, x + 2, y + height - 3, width - 4, 2, shadow);
        ScreenDrawing.coloredRect(context, x + 1, y + 2, 2, height - 4, hilight);
        ScreenDrawing.coloredRect(context, x + width - 3, y + 2, 2, height - 4, shadow);
        ScreenDrawing.coloredRect(context, x + width - 3, y + 2, 1, 1, panel);
        ScreenDrawing.coloredRect(context, x + 2, y + height - 3, 1, 1, panel);
        ScreenDrawing.coloredRect(context, x + 3, y + 3, 1, 1, hilight);
        ScreenDrawing.coloredRect(context, x + width - 4, y + height - 4, 1, 1, shadow);
        ScreenDrawing.coloredRect(context, x + 2, y, width - 4, 1, outline);
        ScreenDrawing.coloredRect(context, x, y + 2, 1, height - 4, outline);
        ScreenDrawing.coloredRect(context, x + width - 1, y + 2, 1, height - 4, outline);
        ScreenDrawing.coloredRect(context, x + 2, y + height - 1, width - 4, 1, outline);
        ScreenDrawing.coloredRect(context, x + 1, y + 1, 1, 1, outline);
        ScreenDrawing.coloredRect(context, x + 1, y + height - 2, 1, 1, outline);
        ScreenDrawing.coloredRect(context, x + width - 2, y + 1, 1, 1, outline);
        ScreenDrawing.coloredRect(context, x + width - 2, y + height - 2, 1, 1, outline);
    }

    public static void drawBeveledPanel(RenderContext context, int x, int y, int width, int height, int topleft, int panel, int bottomright) {
        ScreenDrawing.coloredRect(context, x, y, width, height, panel);
        ScreenDrawing.coloredRect(context, x, y, width - 1, 1, topleft);
        ScreenDrawing.coloredRect(context, x, y + 1, 1, height - 2, topleft);
        ScreenDrawing.coloredRect(context, x + width - 1, y + 1, 1, height - 1, bottomright);
        ScreenDrawing.coloredRect(context, x + 1, y + height - 1, width - 1, 1, bottomright);
    }

    @Deprecated
    public static void drawString(RenderContext context, String s, HorizontalAlignment align, int x, int y, int width, int color) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        switch (align) {
            case LEFT: {
                context.drawString(textRenderer, s, x, y, color, false);
                break;
            }
            case CENTER: {
                int wid = textRenderer.method_1727(s);
                int l = width / 2 - wid / 2;
                context.drawString(textRenderer, s, x + l, y, color, false);
                break;
            }
            case RIGHT: {
                int wid = textRenderer.method_1727(s);
                int l = width - wid;
                context.drawString(textRenderer, s, x + l, y, color, false);
            }
        }
    }

    public static void drawString(RenderContext context, class_5481 text, HorizontalAlignment align, int x, int y, int width, int color) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        switch (align) {
            case LEFT: {
                context.drawString(textRenderer, text, x, y, color, false);
                break;
            }
            case CENTER: {
                int wid = textRenderer.method_30880(text);
                int l = width / 2 - wid / 2;
                context.drawString(textRenderer, text, x + l, y, color, false);
                break;
            }
            case RIGHT: {
                int wid = textRenderer.method_30880(text);
                int l = width - wid;
                context.drawString(textRenderer, text, x + l, y, color, false);
            }
        }
    }

    public static void drawStringWithShadow(RenderContext context, String s, HorizontalAlignment align, int x, int y, int width, int color) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        switch (align) {
            case LEFT: {
                context.drawString(textRenderer, s, x, y, color, true);
                break;
            }
            case CENTER: {
                int wid = textRenderer.method_1727(s);
                int l = width / 2 - wid / 2;
                context.drawString(textRenderer, s, x + l, y, color, true);
                break;
            }
            case RIGHT: {
                int wid = textRenderer.method_1727(s);
                int l = width - wid;
                context.drawString(textRenderer, s, x + l, y, color, true);
            }
        }
    }

    public static void drawStringWithShadow(RenderContext context, class_5481 text, HorizontalAlignment align, int x, int y, int width, int color) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        switch (align) {
            case LEFT: {
                context.drawString(textRenderer, text, x, y, color, true);
                break;
            }
            case CENTER: {
                int wid = textRenderer.method_30880(text);
                int l = width / 2 - wid / 2;
                context.drawString(textRenderer, text, x + l, y, color, true);
                break;
            }
            case RIGHT: {
                int wid = textRenderer.method_30880(text);
                int l = width - wid;
                context.drawString(textRenderer, text, x + l, y, color, true);
            }
        }
    }

    public static void drawString(RenderContext context, String s, int x, int y, int color) {
        context.drawString(class_310.method_1551().field_1772, s, x, y, color, false);
    }

    public static void drawString(RenderContext context, class_5481 text, int x, int y, int color) {
        context.drawString(class_310.method_1551().field_1772, text, x, y, color, false);
    }

    public static void drawTextHover(RenderContext context, @Nullable class_2583 textStyle, int x, int y) {
        context.renderComponentHoverEffect(class_310.method_1551().field_1772, textStyle, x, y);
    }

    public static int colorAtOpacity(int opaque, float opacity) {
        if (opacity < 0.0f) {
            opacity = 0.0f;
        }
        if (opacity > 1.0f) {
            opacity = 1.0f;
        }
        int a = (int)(opacity * 255.0f);
        return opaque & 0xFFFFFF | a << 24;
    }

    public static int multiplyColor(int color, float amount) {
        int a = color & 0xFF000000;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        r = Math.min(r * amount, 1.0f);
        g = Math.min(g * amount, 1.0f);
        b = Math.min(b * amount, 1.0f);
        int ir = (int)(r * 255.0f);
        int ig = (int)(g * 255.0f);
        int ib = (int)(b * 255.0f);
        return a | ir << 16 | ig << 8 | ib;
    }
}

