/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.conditionalmixin.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import me.fallenbreath.conditionalmixin.api.checker.RestrictionChecker;
import me.fallenbreath.conditionalmixin.api.mixin.RestrictionCheckFailureCallback;

public class MemorizedRestrictionChecker
implements RestrictionChecker {
    private final RestrictionChecker checker;
    private final Map<String, Boolean> memory = Maps.newHashMap();

    public MemorizedRestrictionChecker(RestrictionChecker checker) {
        this.checker = checker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkRestriction(String mixinClassName) {
        Map<String, Boolean> map = this.memory;
        synchronized (map) {
            Boolean result = this.memory.get(mixinClassName);
            if (result == null) {
                result = this.checker.checkRestriction(mixinClassName);
                this.memory.put(mixinClassName, result);
            }
            return result;
        }
    }

    @Override
    public void setFailureCallback(RestrictionCheckFailureCallback failureCallback) {
        this.checker.setFailureCallback(failureCallback);
    }
}

