/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.mainhttp.impl;

import io.gitlab.jfronny.libjf.mainhttp.impl.MainHttp;
import io.gitlab.jfronny.libjf.mainhttp.impl.util.Trie;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HttpDecoder
extends ChannelInboundHandlerAdapter {
    private static final Trie<String> METHOD = Trie.of(List.of("GET", "HEAD", "POST", "PUT", "PATCH", "DELETE", "OPTIONS", "TRACE", "CONNECT"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.markReaderIndex();
        boolean passOn = true;
        try {
            Trie current = METHOD;
            while (buf.isReadable() && current != null && current.content == null) {
                current = (Trie)current.next.get(buf.readByte());
            }
            if (current == null || current.content == null) {
                return;
            }
            passOn = false;
            buf.resetReaderIndex();
            byte[] data = new byte[buf.readableBytes()];
            buf.readBytes(data);
            buf.release();
            byte[] response = MainHttp.handle(data);
            if (response == null) {
                passOn = true;
                ctx.channel().pipeline().addLast("libjf_http_404", (ChannelHandler)new NotFoundAdapter());
                return;
            }
            ctx.pipeline().firstContext().writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])response)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        catch (RuntimeException re) {
            MainHttp.LOGGER.error("Could not process HTTP", (Throwable)re);
        }
        finally {
            if (passOn) {
                buf.resetReaderIndex();
                ctx.channel().pipeline().remove((ChannelHandler)this);
                ctx.fireChannelRead(msg);
            }
        }
    }

    private static class NotFoundAdapter
    extends ChannelInboundHandlerAdapter {
        private NotFoundAdapter() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ctx.pipeline().firstContext().writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])MainHttp.NOT_FOUND)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

