/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.web.impl.variant.hosted;

import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.web.api.v1.HttpRequestHandler;
import io.gitlab.jfronny.libjf.web.impl.variant.hosted.HttpConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class HttpServer
extends Thread {
    private int port;
    private int maxConnections;
    private final InetAddress bindAddress;
    private final HttpRequestHandler handler;
    private ThreadPoolExecutor connectionThreads;
    private final Runnable callback;
    private ServerSocket server;
    private State state = State.Initialized;

    public HttpServer(InetAddress bindAddress, int port, int maxConnections, HttpRequestHandler handler, Runnable startCallback) {
        super("LibJF HTTP Server");
        this.port = port;
        this.maxConnections = maxConnections;
        this.bindAddress = bindAddress;
        this.handler = handler;
        this.connectionThreads = null;
        this.callback = startCallback;
    }

    @Override
    public void run() {
        this.close();
        this.connectionThreads = new ThreadPoolExecutor(Math.min(this.maxConnections, 8), this.maxConnections, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        try {
            this.server = new ServerSocket(this.port, this.maxConnections, this.bindAddress);
            this.server.setSoTimeout(1000);
        }
        catch (IOException e) {
            this.state = State.Failed;
            LibJf.LOGGER.error("Error while starting the WebServer!", (Throwable)e);
            return;
        }
        this.callback.run();
        LibJf.LOGGER.info("WebServer started.", new Object[0]);
        while (!this.server.isClosed() && this.server.isBound()) {
            this.state = State.Running;
            try {
                Socket connection = this.server.accept();
                try {
                    this.connectionThreads.execute(new HttpConnection(this.server, connection, this.handler, 10, TimeUnit.SECONDS));
                }
                catch (RejectedExecutionException e) {
                    connection.close();
                    LibJf.LOGGER.warn("Dropped an incoming HttpConnection! (Too many connections?)", new Object[0]);
                }
            }
            catch (SocketException | SocketTimeoutException connection) {
            }
            catch (IOException e) {
                LibJf.LOGGER.error("Error while creating a new HttpConnection!", (Throwable)e);
            }
        }
        this.state = State.Closed;
        LibJf.LOGGER.info("WebServer closed.", new Object[0]);
    }

    public int getPort() {
        return this.server == null ? this.port : this.server.getLocalPort();
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public synchronized void close() {
        this.state = State.Closed;
        if (this.connectionThreads != null) {
            this.connectionThreads.shutdown();
        }
        try {
            if (this.server != null && !this.server.isClosed()) {
                this.server.close();
            }
        }
        catch (IOException e) {
            LibJf.LOGGER.error("Error while closing WebServer!", (Throwable)e);
        }
    }

    public void waitUntilReady() throws InterruptedException {
        while (this.state == State.Initialized) {
            Thread.sleep(1L);
        }
    }

    static enum State {
        Initialized,
        Running,
        Closed,
        Failed;

    }
}

