/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.web.impl.variant.hosted;

import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.web.api.v1.HttpRequest;
import io.gitlab.jfronny.libjf.web.api.v1.HttpRequestHandler;
import io.gitlab.jfronny.libjf.web.api.v1.HttpResponse;
import io.gitlab.jfronny.libjf.web.api.v1.HttpStatusCode;
import io.gitlab.jfronny.libjf.web.impl.util.HttpRequestImpl;
import io.gitlab.jfronny.libjf.web.impl.util.HttpResponseImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class HttpConnection
implements Runnable {
    private final HttpRequestHandler handler;
    private final ServerSocket server;
    private final Socket connection;
    private final InputStream in;
    private final OutputStream out;

    public HttpConnection(ServerSocket server, Socket connection, HttpRequestHandler handler, int timeout, TimeUnit timeoutUnit) throws IOException {
        this.server = server;
        this.connection = connection;
        this.handler = handler;
        if (this.isClosed()) {
            throw new IOException("Socket already closed!");
        }
        connection.setSoTimeout((int)timeoutUnit.toMillis(timeout));
        this.in = this.connection.getInputStream();
        this.out = this.connection.getOutputStream();
    }

    @Override
    public void run() {
        while (!this.isClosed() && !this.server.isClosed()) {
            try {
                HttpRequest request = this.acceptRequest();
                HttpResponse response = this.handler.handle(request);
                this.sendResponse(response);
            }
            catch (InvalidRequestException e) {
                try {
                    this.sendResponse(HttpResponse.create(HttpStatusCode.BAD_REQUEST));
                }
                catch (IOException iOException) {}
                break;
            }
            catch (ConnectionClosedException | SocketException | SocketTimeoutException e) {
                break;
            }
            catch (IOException e) {
                LibJf.LOGGER.error("Unexpected error while processing a HttpRequest!", (Throwable)e);
                break;
            }
        }
        try {
            this.close();
        }
        catch (IOException e) {
            LibJf.LOGGER.error("Error while closing HttpConnection!", (Throwable)e);
        }
    }

    private void log(HttpRequestImpl request, HttpResponseImpl response) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        LibJf.LOGGER.info(this.connection.getInetAddress().toString() + " [ " + dateFormat.format(date) + " ] \"" + request.getMethod() + " " + request.getPath() + " " + request.getVersion() + "\" " + response.getStatusCode().toString(), new Object[0]);
    }

    private void sendResponse(HttpResponse response) throws IOException {
        if (response.getHeader("Server").isEmpty()) {
            response.addHeader("Server", "LibWeb using BlueMapCore");
        }
        response.write(this.out);
        this.out.flush();
    }

    private HttpRequest acceptRequest() throws IOException {
        return HttpRequest.read(this.in);
    }

    public boolean isClosed() {
        return !this.connection.isBound() || this.connection.isClosed() || !this.connection.isConnected() || this.connection.isOutputShutdown() || this.connection.isInputShutdown();
    }

    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            try {
                this.out.close();
            }
            finally {
                this.connection.close();
            }
        }
    }

    public static class InvalidRequestException
    extends IOException {
        private static final long serialVersionUID = 1L;
    }

    public static class ConnectionClosedException
    extends IOException {
        private static final long serialVersionUID = 1L;
    }
}

