/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.web.impl.variant;

import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.web.api.v1.HttpRequest;
import io.gitlab.jfronny.libjf.web.api.v1.HttpResponse;
import io.gitlab.jfronny.libjf.web.api.v1.HttpStatusCode;
import io.gitlab.jfronny.libjf.web.api.v1.PathSegment;
import io.gitlab.jfronny.libjf.web.api.v1.VirtualHostNode;
import io.gitlab.jfronny.libjf.web.api.v1.WebEntrypoint;
import io.gitlab.jfronny.libjf.web.api.v1.WebServer;
import io.gitlab.jfronny.libjf.web.impl.JfWebConfig;
import io.gitlab.jfronny.libjf.web.impl.host.DefaultFileHost;
import io.gitlab.jfronny.libjf.web.impl.host.ReadOnSendDirNode;
import io.gitlab.jfronny.libjf.web.impl.host.RequestHandler;
import io.gitlab.jfronny.libjf.web.impl.util.RunnableEvent;
import io.gitlab.jfronny.libjf.web.impl.util.WebPaths;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.ApiStatus;

public abstract class AbstractWebServer
implements WebServer {
    protected final RequestHandler handler;
    private final DefaultFileHost dfh = new DefaultFileHost();
    private final Event<Runnable> onStart = RunnableEvent.create();
    private final Event<Runnable> onStop = RunnableEvent.create();

    protected AbstractWebServer(RequestHandler handler) {
        this.handler = handler;
    }

    @ApiStatus.Internal
    public RequestHandler getHandler() {
        return this.handler;
    }

    @Override
    public String register(PathSegment path, VirtualHostNode provider) {
        this.handler.register(path, provider);
        return this.toUrl(path);
    }

    @Override
    public String registerFile(PathSegment path, Path file, boolean readOnSend) throws IOException {
        if (readOnSend) {
            if (!Files.exists(file, new LinkOption[0])) {
                throw new FileNotFoundException();
            }
            return this.register(path, (HttpRequest s) -> {
                HttpResponse resp = HttpResponse.create(HttpStatusCode.OK);
                resp.addHeader("Content-Type", Files.probeContentType(file));
                resp.addHeader("Content-Length", String.valueOf(Files.size(file)));
                FileInputStream fs = new FileInputStream(file.toFile());
                resp.setData(fs);
                return resp;
            });
        }
        return this.registerFile(path, Files.readAllBytes(file), Files.probeContentType(file));
    }

    @Override
    public String registerFile(PathSegment path, byte[] data, String contentType) {
        return this.register(path, (HttpRequest s) -> {
            HttpResponse resp = HttpResponse.create(HttpStatusCode.OK);
            resp.addHeader("Content-Type", contentType);
            resp.addHeader("Content-Length", String.valueOf(data.length));
            ByteArrayInputStream fs = new ByteArrayInputStream(data);
            resp.setData(fs);
            return resp;
        });
    }

    @Override
    public String registerDir(PathSegment path, Path dir, boolean readOnSend) throws IOException {
        if (readOnSend) {
            return this.register(path, new ReadOnSendDirNode(dir));
        }
        try (Stream<Path> contentPath = Files.walk(dir, new FileVisitOption[0]);){
            contentPath.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(Files::isReadable).forEach(s -> {
                Path p = dir.toAbsolutePath().normalize().relativize(s.toAbsolutePath().normalize());
                PathSegment subPath = path.concat(PathSegment.of(p.toString()));
                try {
                    this.registerFile(subPath, (Path)s, false);
                }
                catch (IOException e) {
                    LibJf.LOGGER.error("Could not register static file", (Throwable)e);
                }
            });
        }
        return this.toUrl(path);
    }

    private String toUrl(PathSegment path) {
        return WebPaths.concat(this.getServerRoot(), path.toString());
    }

    @Override
    public void onStart(Runnable listener) {
        this.onStart.register((Object)listener);
    }

    protected void emitStart() {
        ((Runnable)this.onStart.invoker()).run();
    }

    @Override
    public void onStop(Runnable listener) {
        this.onStop.register((Object)listener);
    }

    protected void emitStop() {
        ((Runnable)this.onStop.invoker()).run();
    }

    protected void performRegistrations() {
        if (JfWebConfig.enableFileHost) {
            this.dfh.register(this);
        }
        FabricLoader.getInstance().getEntrypointContainers("libjf:web", WebEntrypoint.class).forEach(entrypoint -> {
            WebEntrypoint init = (WebEntrypoint)entrypoint.getEntrypoint();
            init.register(this);
        });
    }

    protected String getServerRoot(int hostedPort) {
        return WebPaths.getHttp(JfWebConfig.serverIp) + ":" + (JfWebConfig.portOverride != -1 ? JfWebConfig.portOverride : hostedPort);
    }
}

