/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.web.impl.util;

public class WebPaths {
    public static String concat(String s1, String s2) {
        return WebPaths.simplify(s1) + "/" + WebPaths.simplify(s2);
    }

    public static String getHttp(String ip) {
        if (!((String)ip).startsWith("http")) {
            ip = "http://" + (String)ip;
        }
        return WebPaths.simplify((String)ip);
    }

    public static String simplify(String s) {
        boolean http = false;
        boolean https = false;
        if (s.startsWith("http://")) {
            http = true;
            s = s.substring(7);
        }
        if (s.startsWith("https://")) {
            https = true;
            s = s.substring(8);
        }
        StringBuilder q = new StringBuilder();
        for (String s1 : WebPaths.simplifyPart(s, false).split("/")) {
            String w = WebPaths.simplifyPart(s1, true);
            if (w == null || w.isEmpty()) continue;
            q.append("/").append(w);
        }
        Object result = WebPaths.simplifyPart(q.toString(), false);
        if (http) {
            result = "http://" + (String)result;
        }
        if (https) {
            result = "https://" + (String)result;
        }
        return result;
    }

    private static String simplifyPart(String s, boolean alpha) {
        String path = s.toLowerCase();
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path.startsWith(".")) {
            path = path.substring(1);
        }
        while (path.endsWith(".")) {
            path = path.substring(0, path.length() - 1);
        }
        if (alpha) {
            path = path.replaceAll("[^A-Za-z0-9.:]", "");
        }
        return path;
    }
}

