/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.web.impl.util;

import io.gitlab.jfronny.libjf.web.api.v1.HttpRequest;
import io.gitlab.jfronny.libjf.web.impl.variant.hosted.HttpConnection;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpRequestImpl
implements HttpRequest {
    private static final Pattern REQUEST_PATTERN = Pattern.compile("^(\\w+) (\\S+) (.+)$");
    private final String method;
    private final String address;
    private final String version;
    private final Map<String, Set<String>> header;
    private final Map<String, Set<String>> headerLC;
    private byte[] data;
    private String path = null;
    private Map<String, String> queryParameters = null;
    private String queryString = null;

    public HttpRequestImpl(String method, String address, String version, Map<String, Set<String>> header) {
        this.method = method;
        this.address = address;
        this.version = version;
        this.header = header;
        this.headerLC = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> e : header.entrySet()) {
            HashSet<String> values = new HashSet<String>();
            for (String v : e.getValue()) {
                values.add(v.toLowerCase());
            }
            this.headerLC.put(e.getKey().toLowerCase(), values);
        }
        this.data = new byte[0];
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Map<String, Set<String>> getHeader() {
        return this.header;
    }

    @Override
    public Map<String, Set<String>> getLowercaseHeader() {
        return this.headerLC;
    }

    @Override
    public Set<String> getHeader(String key) {
        Set<String> headerValues = this.header.get(key);
        if (headerValues == null) {
            return Collections.emptySet();
        }
        return headerValues;
    }

    @Override
    public Set<String> getLowercaseHeader(String key) {
        Set<String> headerValues = this.headerLC.get(key.toLowerCase());
        if (headerValues == null) {
            return Collections.emptySet();
        }
        return headerValues;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            this.parseAddress();
        }
        return this.path;
    }

    @Override
    public Map<String, String> getQuery() {
        if (this.queryParameters == null) {
            this.parseAddress();
        }
        return Collections.unmodifiableMap(this.queryParameters);
    }

    @Override
    public String getQueryString() {
        if (this.queryString == null) {
            this.parseAddress();
        }
        return this.queryString;
    }

    private void parseAddress() {
        String adress = this.address;
        if (adress.isEmpty()) {
            adress = "/";
        }
        String[] addressParts = adress.split("\\?", 2);
        String path = addressParts[0];
        this.queryString = addressParts.length > 1 ? addressParts[1] : "";
        HashMap<String, String> queryParams = new HashMap<String, String>();
        for (String queryParam : this.queryString.split("&")) {
            if (queryParam.isEmpty()) continue;
            String[] kv = queryParam.split("=", 2);
            String key = kv[0];
            String value = kv.length > 1 ? kv[1] : "";
            queryParams.put(key, value);
        }
        this.path = path;
        this.queryParameters = queryParams;
    }

    @Override
    public InputStream getData() {
        return new ByteArrayInputStream(this.data);
    }

    public static HttpRequestImpl read(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        HttpRequestImpl request = HttpRequestImpl.fromHeaders(HttpRequestImpl.extractHeaders(reader));
        HttpRequestImpl.readData(in, request, reader);
        return request;
    }

    private static void readData(InputStream in, HttpRequestImpl request, BufferedReader reader) throws IOException {
        if (request.getLowercaseHeader("Transfer-Encoding").contains("chunked")) {
            try {
                String hexSize;
                int chunkSize;
                ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
                while (dataStream.size() < 1000000 && (chunkSize = Integer.parseInt(hexSize = reader.readLine(), 16)) > 0) {
                    byte[] data = new byte[chunkSize];
                    in.read(data);
                    dataStream.write(data);
                }
                if (dataStream.size() >= 1000000) {
                    throw new HttpConnection.InvalidRequestException();
                }
                request.data = dataStream.toByteArray();
            }
            catch (NumberFormatException dataStream) {}
        } else {
            Set<String> clSet = request.getLowercaseHeader("Content-Length");
            if (clSet.isEmpty()) {
                return;
            }
            try {
                int cl = Integer.parseInt(clSet.iterator().next());
                byte[] data = new byte[cl];
                in.read(data);
                request.data = data;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static List<String> extractHeaders(BufferedReader reader) throws IOException {
        String headerLine;
        ArrayList<String> headers = new ArrayList<String>(20);
        while (headers.size() < 1000 && !(headerLine = HttpRequestImpl.readLine(reader)).isEmpty()) {
            headers.add(headerLine);
        }
        return headers;
    }

    private static HttpRequestImpl fromHeaders(List<String> headers) throws HttpConnection.InvalidRequestException {
        if (headers.isEmpty()) {
            throw new HttpConnection.InvalidRequestException();
        }
        Matcher m = REQUEST_PATTERN.matcher(headers.remove(0));
        if (!m.find()) {
            throw new HttpConnection.InvalidRequestException();
        }
        String method = m.group(1);
        if (method == null) {
            throw new HttpConnection.InvalidRequestException();
        }
        String adress = m.group(2);
        if (adress == null) {
            throw new HttpConnection.InvalidRequestException();
        }
        String version = m.group(3);
        if (version == null) {
            throw new HttpConnection.InvalidRequestException();
        }
        return new HttpRequestImpl(method, adress, version, HttpRequestImpl.parseExtraHeaders(headers));
    }

    private static Map<String, Set<String>> parseExtraHeaders(List<String> header) {
        HashMap<String, Set<String>> headerMap = new HashMap<String, Set<String>>();
        for (String line : header) {
            String[] kv;
            if (line.trim().isEmpty() || (kv = line.split(":", 2)).length < 2) continue;
            HashSet<String> values = new HashSet<String>();
            if (kv[0].trim().equalsIgnoreCase("If-Modified-Since")) {
                values.add(kv[1].trim());
            } else {
                for (String v : kv[1].split(",")) {
                    values.add(v.trim());
                }
            }
            headerMap.put(kv[0].trim(), values);
        }
        return headerMap;
    }

    private static String readLine(BufferedReader in) throws IOException {
        String line = in.readLine();
        if (line == null) {
            throw new HttpConnection.ConnectionClosedException();
        }
        return line;
    }
}

