/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.web.impl.host;

import io.gitlab.jfronny.libjf.web.api.v1.HttpRequest;
import io.gitlab.jfronny.libjf.web.api.v1.HttpRequestHandler;
import io.gitlab.jfronny.libjf.web.api.v1.HttpResponse;
import io.gitlab.jfronny.libjf.web.api.v1.HttpStatusCode;
import io.gitlab.jfronny.libjf.web.api.v1.PathSegment;
import io.gitlab.jfronny.libjf.web.api.v1.VirtualHostNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class VirtualHostBranch
implements VirtualHostNode {
    protected final Map<String, VirtualHostNode> children = new HashMap<String, VirtualHostNode>();
    protected HttpRequestHandler content;

    @Override
    public HttpResponse handle(HttpRequest request, @Nullable PathSegment path) throws IOException {
        if (path == null) {
            if (this.content != null) {
                return this.content.handle(request);
            }
            return request.createResponse(HttpStatusCode.NOT_FOUND);
        }
        VirtualHostNode child = this.children.get(path.segment());
        if (child == null) {
            return request.createResponse(HttpStatusCode.NOT_FOUND);
        }
        return child.handle(request, path.next());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void register(PathSegment path, VirtualHostNode node) {
        Objects.requireNonNull(path);
        if (path.next() == null) {
            if (this.children.containsKey(path.segment())) {
                VirtualHostNode childNode = this.children.get(path.segment());
                if (!(node instanceof VirtualHostBranch)) throw new UnsupportedOperationException("VirtualHostNode already exists for path and merging is unsupported for " + String.valueOf(childNode.getClass()) + " and " + String.valueOf(node.getClass()));
                VirtualHostBranch next = (VirtualHostBranch)node;
                if (!(childNode instanceof VirtualHostBranch)) throw new UnsupportedOperationException("VirtualHostNode already exists for path and merging is unsupported for " + String.valueOf(childNode.getClass()) + " and " + String.valueOf(node.getClass()));
                VirtualHostBranch source = (VirtualHostBranch)childNode;
                if (next.content != null) {
                    source.setContent(next.content);
                }
                next.children.forEach((k, v) -> source.register(PathSegment.of(k), (VirtualHostNode)v));
                return;
            } else {
                this.children.put(path.segment(), node);
            }
            return;
        } else {
            VirtualHostNode child = this.children.computeIfAbsent(path.segment(), s -> new VirtualHostBranch());
            if (!(child instanceof VirtualHostBranch)) throw new UnsupportedOperationException("Cannot register VirtualHostNode to non-branch VirtualHostNode " + String.valueOf(child.getClass()));
            VirtualHostBranch source = (VirtualHostBranch)child;
            source.register(path.next(), node);
        }
    }

    public void setContent(HttpRequestHandler content) {
        if (this.content != null) {
            throw new UnsupportedOperationException("Content already set for virtual host node");
        }
        this.content = Objects.requireNonNull(content);
    }
}

