/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.player;

import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.server.entity.player.McServerPlayer;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.event.connection.TcpPacketSendEvent;
import su.plo.voice.api.server.event.player.PlayerInfoCreateEvent;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.proto.data.player.VoicePlayerInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.PacketTcpCodec;
import su.plo.voice.server.player.BaseVoicePlayer;

public final class VoiceServerPlayerEntity
extends BaseVoicePlayer<McServerPlayer>
implements VoiceServerPlayer {
    private final PlasmoVoiceServer voiceServer;

    public VoiceServerPlayerEntity(@NotNull PlasmoVoiceServer voiceServer, @NotNull McServerPlayer player) {
        super(voiceServer, player);
        this.voiceServer = voiceServer;
    }

    @Override
    public void sendPacket(@NotNull Packet<?> packet) {
        TcpPacketSendEvent event = new TcpPacketSendEvent(this, packet);
        if (!this.voiceServer.getEventBus().fire(event)) {
            return;
        }
        byte[] encoded = PacketTcpCodec.encode(packet);
        ((McServerPlayer)this.instance).sendPacket("plasmo:voice/v2", encoded);
    }

    @Override
    public boolean hasVoiceChat() {
        return this.voiceServer.getUdpConnectionManager().getConnectionByPlayerId(((McServerPlayer)this.instance).getUuid()).isPresent();
    }

    @Override
    public VoicePlayerInfo createPlayerInfo() {
        if (!this.hasVoiceChat()) {
            throw new IllegalStateException("Player is not connected to UDP server");
        }
        VoicePlayerInfo voicePlayerInfo = new VoicePlayerInfo(((McServerPlayer)this.instance).getUuid(), ((McServerPlayer)this.instance).getName(), this.voiceServer.getMuteManager().getMute(((McServerPlayer)this.instance).getUuid()).isPresent(), this.isVoiceDisabled(), this.isMicrophoneMuted());
        PlayerInfoCreateEvent event = new PlayerInfoCreateEvent(this, voicePlayerInfo);
        this.voiceServer.getEventBus().fire(event);
        return event.getVoicePlayerInfo();
    }

    @Override
    public String toString() {
        return "VoiceServerPlayerEntity(super=" + super.toString() + ", voiceServer=" + this.voiceServer + ")";
    }
}

