/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.udp.serverbound;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.udp.bothbound.BaseAudioPacket;
import su.plo.voice.proto.packets.udp.serverbound.ServerPacketUdpHandler;

public final class PlayerAudioPacket
extends BaseAudioPacket<ServerPacketUdpHandler> {
    private UUID activationId;
    private short distance;
    private boolean stereo;

    public PlayerAudioPacket(long sequenceNumber, byte[] data, @NotNull UUID activationId, short distance, boolean stereo) {
        super(sequenceNumber, data);
        this.activationId = (UUID)Preconditions.checkNotNull((Object)activationId);
        this.distance = distance;
        this.stereo = stereo;
    }

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        super.read(in);
        this.activationId = PacketUtil.readUUID(in);
        this.distance = in.readShort();
        this.stereo = in.readBoolean();
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        super.write(out);
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.activationId));
        out.writeShort((int)this.distance);
        out.writeBoolean(this.stereo);
    }

    @Override
    public void handle(ServerPacketUdpHandler handler) {
        handler.handle(this);
    }

    public PlayerAudioPacket() {
    }

    @Override
    public String toString() {
        return "PlayerAudioPacket(activationId=" + this.getActivationId() + ", distance=" + this.getDistance() + ", stereo=" + this.isStereo() + ")";
    }

    public UUID getActivationId() {
        return this.activationId;
    }

    public short getDistance() {
        return this.distance;
    }

    public boolean isStereo() {
        return this.stereo;
    }
}

