/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.clientbound;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.UUID;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;

public final class SourceAudioEndPacket
implements Packet<ClientPacketTcpHandler> {
    private UUID sourceId;
    private long sequenceNumber;

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.sourceId = PacketUtil.readUUID(in);
        this.sequenceNumber = in.readLong();
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.sourceId));
        out.writeLong(this.sequenceNumber);
    }

    @Override
    public void handle(ClientPacketTcpHandler handler) {
        handler.handle(this);
    }

    public SourceAudioEndPacket(UUID sourceId, long sequenceNumber) {
        this.sourceId = sourceId;
        this.sequenceNumber = sequenceNumber;
    }

    public SourceAudioEndPacket() {
    }

    public String toString() {
        return "SourceAudioEndPacket(sourceId=" + this.getSourceId() + ", sequenceNumber=" + this.getSequenceNumber() + ")";
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }
}

