/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.socket;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.event.connection.ServerInfoInitializedEvent;
import su.plo.voice.api.client.event.connection.UdpClientPacketSendEvent;
import su.plo.voice.api.client.event.socket.UdpClientClosedEvent;
import su.plo.voice.api.client.event.socket.UdpClientConnectedEvent;
import su.plo.voice.api.client.event.socket.UdpClientTimedOutEvent;
import su.plo.voice.api.client.socket.UdpClient;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.socket.NettyUdpClientHandler;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.udp.PacketUdpCodec;
import su.plo.voice.socket.NettyPacketUdpDecoder;

public final class NettyUdpClient
implements UdpClient {
    private final PlasmoVoiceClient voiceClient;
    private final UUID secret;
    private final EventLoopGroup workGroup = new NioEventLoopGroup();
    private final NettyUdpClientHandler handler;
    private NioDatagramChannel channel;
    private boolean closed;
    private boolean connected;
    private boolean timedOut;

    public NettyUdpClient(@NotNull BaseVoiceClient voiceClient, @NotNull VoiceClientConfig config, @NotNull UUID secret) {
        this.voiceClient = (PlasmoVoiceClient)Preconditions.checkNotNull((Object)voiceClient, (Object)"voiceClient");
        this.secret = (UUID)Preconditions.checkNotNull((Object)secret, (Object)"secret");
        this.handler = new NettyUdpClientHandler(voiceClient, config, this);
    }

    @Override
    public void connect(@NotNull String ip, int port) {
        if (this.isClosed()) {
            throw new IllegalStateException("Client is closed and cannot be reused");
        }
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(this.workGroup);
        bootstrap.channel(NioDatagramChannel.class);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<NioDatagramChannel>(){

            protected void initChannel(@NotNull NioDatagramChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new NettyPacketUdpDecoder());
                pipeline.addLast("handler", (ChannelHandler)NettyUdpClient.this.handler);
            }
        });
        try {
            BaseVoice.LOGGER.info("Connecting to {}:{}", ip, port);
            ChannelFuture channelFuture = bootstrap.connect(ip, port).sync();
            this.channel = (NioDatagramChannel)channelFuture.channel();
        }
        catch (InterruptedException e) {
            this.close(UdpClientClosedEvent.Reason.FAILED_TO_CONNECT);
        }
        catch (Exception e) {
            this.close(UdpClientClosedEvent.Reason.FAILED_TO_CONNECT);
            throw e;
        }
    }

    @Override
    public void close(@NotNull UdpClientClosedEvent.Reason reason) {
        if (this.channel == null) {
            BaseVoice.LOGGER.info("Disconnecting before connecting with reason {}", new Object[]{reason});
        } else {
            BaseVoice.LOGGER.info("Disconnecting from {} with reason {}", new Object[]{this.channel.remoteAddress(), reason});
        }
        this.handler.close();
        this.workGroup.shutdownGracefully();
        this.closed = true;
        this.connected = false;
        this.voiceClient.getEventBus().unregister((Object)this.voiceClient, this);
        this.voiceClient.getEventBus().fire(new UdpClientClosedEvent(this, reason));
    }

    @Override
    public void sendPacket(Packet<?> packet) {
        byte[] encoded = PacketUdpCodec.encode(packet, this.secret);
        if (encoded == null) {
            return;
        }
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])encoded);
        BaseVoice.LOGGER.debug("UDP packet {} sent to {}", packet, this.channel.remoteAddress());
        UdpClientPacketSendEvent event = new UdpClientPacketSendEvent(this, packet);
        if (!this.voiceClient.getEventBus().fire(event)) {
            return;
        }
        this.channel.writeAndFlush((Object)new DatagramPacket(buf, this.channel.remoteAddress()));
    }

    @Override
    public Optional<InetSocketAddress> getRemoteAddress() {
        return this.channel != null ? Optional.ofNullable(this.channel.remoteAddress()) : Optional.empty();
    }

    public void setTimedOut(boolean timedOut) {
        if (timedOut != this.timedOut) {
            this.voiceClient.getEventBus().fire(new UdpClientTimedOutEvent(this, timedOut));
        }
        this.timedOut = timedOut;
    }

    @EventSubscribe
    public void onServerInfoUpdate(ServerInfoInitializedEvent event) {
        if (this.connected) {
            return;
        }
        BaseVoice.LOGGER.info("Connected to {}", this.channel.remoteAddress());
        this.connected = true;
        this.voiceClient.getEventBus().fire(new UdpClientConnectedEvent(this));
    }

    @Override
    public UUID getSecret() {
        return this.secret;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isTimedOut() {
        return this.timedOut;
    }
}

