/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.filter;

import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.ConfigEntry;
import su.plo.voice.api.client.audio.filter.AudioFilter;
import su.plo.voice.api.client.audio.filter.AudioFilterContext;
import su.plo.voice.api.util.AudioUtil;

public final class StereoToMonoFilter
implements AudioFilter {
    private final ConfigEntry<Boolean> activeEntry;

    @Override
    @NotNull
    public String getName() {
        return "stereo_to_mono";
    }

    @Override
    public short[] process(@NotNull AudioFilterContext context, short[] samples) {
        context.setChannels(1);
        return AudioUtil.convertToMonoShorts(samples);
    }

    @Override
    public boolean isEnabled() {
        return this.activeEntry.value();
    }

    @Override
    public int getSupportedChannels() {
        return 2;
    }

    public StereoToMonoFilter(ConfigEntry<Boolean> activeEntry) {
        this.activeEntry = activeEntry;
    }
}

