/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.addon;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import su.plo.voice.api.PlasmoVoice;

public final class AddonClassLoader
extends URLClassLoader {
    private static final Set<AddonClassLoader> loaders = new CopyOnWriteArraySet<AddonClassLoader>();

    public AddonClassLoader(URL[] urls) {
        super(urls, PlasmoVoice.class.getClassLoader());
    }

    public void addToClassloaders() {
        loaders.add(this);
    }

    @Override
    public void close() throws IOException {
        loaders.remove(this);
        super.close();
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass0(name, resolve, true);
    }

    private Class<?> loadClass0(String name, boolean resolve, boolean checkOther) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (checkOther) {
                for (AddonClassLoader loader : loaders) {
                    if (loader == this) continue;
                    try {
                        return loader.loadClass0(name, resolve, false);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                    }
                }
            }
            throw new ClassNotFoundException(name);
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

