/*
 * Decompiled with CFR 0.152.
 */
package su.plo.config.toml;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import su.plo.config.toml.Context;
import su.plo.config.toml.DatePolicy;
import su.plo.config.toml.Results;
import su.plo.config.toml.ValueReader;
import su.plo.config.toml.ValueWriter;
import su.plo.config.toml.WriterContext;

class DateValueReaderWriter
implements ValueReader,
ValueWriter {
    static final DateValueReaderWriter DATE_VALUE_READER_WRITER = new DateValueReaderWriter();
    static final DateValueReaderWriter DATE_PARSER_JDK_6 = new DateConverterJdk6();
    private static final Pattern DATE_REGEX = Pattern.compile("(\\d{4}-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-5][0-9]:[0-5][0-9])(\\.\\d*)?(Z|(?:[+\\-]\\d{2}:\\d{2}))(.*)");

    @Override
    public boolean canRead(String s) {
        if (s.length() < 5) {
            return false;
        }
        for (int i = 0; i < 5; ++i) {
            char c = s.charAt(i);
            if (!(i < 4 ? !Character.isDigit(c) : c != '-')) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object read(String original, AtomicInteger index, Context context) {
        String s;
        Matcher matcher;
        StringBuilder sb = new StringBuilder();
        int i = index.get();
        while (i < original.length()) {
            char c = original.charAt(i);
            if (!Character.isDigit(c) && c != '-' && c != '+' && c != ':' && c != '.' && c != 'T' && c != 'Z') {
                index.decrementAndGet();
                break;
            }
            sb.append(c);
            i = index.incrementAndGet();
        }
        if (!(matcher = DATE_REGEX.matcher(s = sb.toString())).matches()) {
            Results.Errors errors = new Results.Errors();
            errors.invalidValue(context.identifier.getName(), s, context.line.get());
            return errors;
        }
        String dateString = matcher.group(1);
        String zone = matcher.group(3);
        String fractionalSeconds = matcher.group(2);
        String format = "yyyy-MM-dd'T'HH:mm:ss";
        if (fractionalSeconds != null && !fractionalSeconds.isEmpty()) {
            format = format + ".SSS";
            dateString = dateString + fractionalSeconds;
        }
        format = format + "Z";
        if ("Z".equals(zone)) {
            dateString = dateString + "+0000";
        } else if (zone.contains(":")) {
            dateString = dateString + zone.replace(":", "");
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            dateFormat.setLenient(false);
            return dateFormat.parse(dateString);
        }
        catch (Exception e) {
            Results.Errors errors = new Results.Errors();
            errors.invalidValue(context.identifier.getName(), s, context.line.get());
            return errors;
        }
    }

    @Override
    public boolean canWrite(Object value) {
        return value instanceof Date;
    }

    @Override
    public void write(Object value, WriterContext context) {
        DateFormat formatter = this.getFormatter(context.getDatePolicy());
        context.write(formatter.format(value));
    }

    @Override
    public boolean isPrimitiveType() {
        return true;
    }

    private DateFormat getFormatter(DatePolicy datePolicy) {
        boolean utc = "UTC".equals(datePolicy.getTimeZone().getID());
        String format = utc && datePolicy.isShowFractionalSeconds() ? "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'" : (utc ? "yyyy-MM-dd'T'HH:mm:ss'Z'" : (datePolicy.isShowFractionalSeconds() ? this.getTimeZoneAndFractionalSecondsFormat() : this.getTimeZoneFormat()));
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(datePolicy.getTimeZone());
        return formatter;
    }

    String getTimeZoneFormat() {
        return "yyyy-MM-dd'T'HH:mm:ssXXX";
    }

    String getTimeZoneAndFractionalSecondsFormat() {
        return "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    }

    private DateValueReaderWriter() {
    }

    public String toString() {
        return "datetime";
    }

    private static class DateConverterJdk6
    extends DateValueReaderWriter {
        private DateConverterJdk6() {
        }

        @Override
        public void write(Object value, WriterContext context) {
            DateFormat formatter = ((DateValueReaderWriter)this).getFormatter(context.getDatePolicy());
            String date = formatter.format(value);
            if ("UTC".equals(context.getDatePolicy().getTimeZone().getID())) {
                context.write(date);
            } else {
                int insertionIndex = date.length() - 2;
                context.write(date.substring(0, insertionIndex)).write(':').write(date.substring(insertionIndex));
            }
        }

        @Override
        String getTimeZoneAndFractionalSecondsFormat() {
            return "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
        }

        @Override
        String getTimeZoneFormat() {
            return "yyyy-MM-dd'T'HH:mm:ssZ";
        }
    }
}

