/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.json.impl;

import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.Token;
import io.gitlab.jfronny.commons.serialize.databind.api.SerializerFor;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeAdapter;
import io.gitlab.jfronny.muscript.data.additional.DDate;
import io.gitlab.jfronny.muscript.data.additional.DEnum;
import io.gitlab.jfronny.muscript.data.additional.DTime;
import io.gitlab.jfronny.muscript.data.dynamic.DNull;
import io.gitlab.jfronny.muscript.data.dynamic.Dynamic;
import io.gitlab.jfronny.muscript.data.dynamic.DynamicBase;
import io.gitlab.jfronny.muscript.json.impl.DynamicTypeAdapterHolder;
import io.gitlab.jfronny.muscript.json.impl.typed.DBoolTypeAdapter;
import io.gitlab.jfronny.muscript.json.impl.typed.DCallableTypeAdapter;
import io.gitlab.jfronny.muscript.json.impl.typed.DListTypeAdapter;
import io.gitlab.jfronny.muscript.json.impl.typed.DNullTypeAdapter;
import io.gitlab.jfronny.muscript.json.impl.typed.DNumberTypeAdapter;
import io.gitlab.jfronny.muscript.json.impl.typed.DObjectTypeAdapter;
import io.gitlab.jfronny.muscript.json.impl.typed.DStringTypeAdapter;
import io.gitlab.jfronny.muscript.json.impl.typed.DynamicBaseTypeAdapter;
import io.gitlab.jfronny.muscript.json.impl.typed.additional.DDateTypeAdapter;
import io.gitlab.jfronny.muscript.json.impl.typed.additional.DEnumTypeAdapter;
import io.gitlab.jfronny.muscript.json.impl.typed.additional.DTimeTypeAdapter;

@SerializerFor(targets={Dynamic.class})
public class DynamicTypeAdapter
extends TypeAdapter<Dynamic> {
    public final DObjectTypeAdapter dObject = new DObjectTypeAdapter();
    public final DListTypeAdapter dList = new DListTypeAdapter();
    public final DNullTypeAdapter dNull = new DNullTypeAdapter();
    public final DBoolTypeAdapter dBool = new DBoolTypeAdapter();
    public final DNumberTypeAdapter dNumber = new DNumberTypeAdapter();
    public final DStringTypeAdapter dString = new DStringTypeAdapter();
    public final DCallableTypeAdapter dCallable = new DCallableTypeAdapter();
    public final DynamicBaseTypeAdapter dynamicBase = new DynamicBaseTypeAdapter();
    public final DDateTypeAdapter dDate = new DDateTypeAdapter();
    public final DTimeTypeAdapter dTime = new DTimeTypeAdapter();
    public final DEnumTypeAdapter dEnum = new DEnumTypeAdapter();

    public DynamicTypeAdapter() {
        DynamicTypeAdapterHolder.setInstance(this);
    }

    public <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(Dynamic value, Writer writer) throws TEx, MalformedDataException {
        if (value == null) {
            writer.nullValue();
        } else if (value instanceof DDate) {
            DDate date = (DDate)value;
            this.dDate.serialize(date, writer);
        } else if (value instanceof DTime) {
            DTime time = (DTime)value;
            this.dTime.serialize(time, writer);
        } else if (value instanceof DEnum) {
            DEnum enm = (DEnum)value;
            this.dEnum.serialize(enm, writer);
        } else if (value.isObject()) {
            this.dObject.serialize(value.asObject(), writer);
        } else if (value.isList()) {
            this.dList.serialize(value.asList(), writer);
        } else if (value instanceof DNull) {
            DNull n = (DNull)value;
            this.dNull.serialize(n, writer);
        } else if (value.isBool()) {
            this.dBool.serialize(value.asBool(), writer);
        } else if (value.isNumber()) {
            this.dNumber.serialize(value.asNumber(), writer);
        } else if (value.isString()) {
            this.dString.serialize(value.asString(), writer);
        } else if (value.isCallable()) {
            this.dCallable.serialize(value.asCallable(), writer);
        } else if (value instanceof DynamicBase) {
            DynamicBase base = (DynamicBase)value;
            this.dynamicBase.serialize(base, writer);
        } else {
            throw new IllegalArgumentException("Unexpected dynamic type for: " + String.valueOf(value));
        }
    }

    public <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> Dynamic deserialize(Reader reader) throws TEx, MalformedDataException {
        return switch (reader.peek()) {
            case Token.BEGIN_OBJECT -> this.dObject.deserialize(reader);
            case Token.BEGIN_ARRAY -> this.dList.deserialize(reader);
            case Token.NULL -> this.dNull.deserialize(reader);
            case Token.BOOLEAN -> this.dBool.deserialize(reader);
            case Token.NUMBER -> this.dNumber.deserialize(reader);
            case Token.STRING -> this.dString.deserialize(reader);
            default -> throw new IllegalStateException("Unsupported token for beginning of Dynamic: " + String.valueOf(reader.peek()));
        };
    }
}

