/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.muscript.json;

import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.Transport;
import io.gitlab.jfronny.muscript.data.additional.DFinal;
import io.gitlab.jfronny.muscript.data.additional.context.Scope;
import io.gitlab.jfronny.muscript.data.additional.libs.IntentionalException;
import io.gitlab.jfronny.muscript.data.dynamic.DList;
import io.gitlab.jfronny.muscript.data.dynamic.DString;
import io.gitlab.jfronny.muscript.data.dynamic.Dynamic;
import io.gitlab.jfronny.muscript.data.dynamic.type.DSL;
import io.gitlab.jfronny.muscript.data.dynamic.type.DType;
import io.gitlab.jfronny.muscript.data.dynamic.type.DTypeCallable;
import io.gitlab.jfronny.muscript.json.impl.DynamicTypeAdapter;
import java.io.StringWriter;
import java.io.Writer;

public class TransportLib<TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> {
    private final DynamicTypeAdapter adapter = new DynamicTypeAdapter();
    private final String serializeName;
    private final String deserializeName;
    private final Transport<TEx, Reader, Writer> lenientTransport;
    private final Transport<TEx, Reader, Writer> strictTransport;
    private final DType serialize = DSL.callable((DType)DSL.STRING, (DTypeCallable.Arg[])new DTypeCallable.Arg[]{DSL.arg((String)"value", (DType)DSL.generic((int)0))}).and((DType)DSL.callable((DType)DSL.STRING, (DTypeCallable.Arg[])new DTypeCallable.Arg[]{DSL.arg((String)"value", (DType)DSL.generic((int)0)), DSL.arg((String)"lenient", (DType)DSL.BOOL)}));
    private final DType deserialize = DSL.callable((DType)DSL.generic((int)0), (DTypeCallable.Arg[])new DTypeCallable.Arg[]{DSL.arg((String)"source", (DType)DSL.STRING)}).and((DType)DSL.callable((DType)DSL.generic((int)0), (DTypeCallable.Arg[])new DTypeCallable.Arg[]{DSL.arg((String)"source", (DType)DSL.STRING), DSL.arg((String)"lenient", (DType)DSL.BOOL)}));

    public TransportLib(Transport<TEx, Reader, Writer> lenientTransport, Transport<TEx, Reader, Writer> strictTransport, String serializeName, String deserializeName) {
        this.lenientTransport = lenientTransport;
        this.strictTransport = strictTransport;
        this.serializeName = serializeName;
        this.deserializeName = deserializeName;
    }

    public Scope addTo(Scope scope) {
        return scope.set(this.serializeName, this.serialize, this::serialize).set(this.deserializeName, this.deserialize, this::deserialize);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public DString serialize(DList args) {
        if (args.isEmpty() || args.size() > 2) {
            throw new IllegalArgumentException("Invalid number of arguments for toJson: expected 1 or 2 but got " + args.size());
        }
        Dynamic source = args.get(0);
        boolean lenient = args.size() > 1 && args.get(1).asBool().getValue() != false;
        try (StringWriter sw = new StringWriter();){
            DString dString;
            block14: {
                SerializeWriter writer = (lenient ? this.lenientTransport : this.strictTransport).createWriter((Writer)sw);
                try {
                    this.adapter.serialize(source, writer);
                    writer.close();
                    dString = DFinal.of((String)sw.toString());
                    if (writer == null) break block14;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return dString;
        }
        catch (Throwable e) {
            throw new IntentionalException("Could not serialize value: " + e.getMessage());
        }
    }

    public Dynamic deserialize(DList args) {
        Dynamic dynamic;
        block9: {
            if (args.isEmpty() || args.size() > 2) {
                throw new IllegalArgumentException("Invalid number of arguments for fromJson: expected 1 or 2 but got " + args.size());
            }
            String source = args.get(0).asString().getValue();
            boolean lenient = args.size() > 1 && args.get(1).asBool().getValue() != false;
            SerializeReader reader = (lenient ? this.lenientTransport : this.strictTransport).createReader(source);
            try {
                dynamic = this.adapter.deserialize(reader);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new IntentionalException("Could not deserialize value: " + e.getMessage());
                }
            }
            reader.close();
        }
        return dynamic;
    }
}

