/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.tuple;

import io.gitlab.jfronny.commons.throwable.ThrowingPredicate;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import io.gitlab.jfronny.commons.tuple.Quadruple;
import io.gitlab.jfronny.commons.tuple.Triple;
import io.gitlab.jfronny.commons.tuple.Tuple;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Single<T1>(@Nullable T1 val) {
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1> Single<T1> of(@Nullable T1 val) {
        return new Single<T1>(val);
    }

    @Contract(pure=true)
    public boolean isNull() {
        return this.val == null;
    }

    @Contract(pure=true)
    public boolean isPresent() {
        return this.val != null;
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public ThrowingPredicate<T1, RuntimeException> asEqualsPredicate() {
        return this.val == null ? Objects::isNull : this.val::equals;
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public ThrowingPredicate<T1, RuntimeException> asIdentityEqualsPredicate() {
        return v -> v == this.val;
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public ThrowingSupplier<T1, RuntimeException> asSupplier() {
        return () -> this.val;
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public <T> Single<T> map(@NotNull Function<T1, T> mapper) {
        return new Single<T>(Objects.requireNonNull(mapper).apply(this.val));
    }

    @Contract(pure=true)
    @Nullable
    public T1 get() {
        return this.val;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T2> Tuple<T1, T2> concat(@Nullable T2 val) {
        return Tuple.of(this.val, val);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public <T2, T3> Triple<T1, T2, T3> concat(@Nullable T2 val2, @Nullable T3 val3) {
        return Triple.of(this.val, val2, val3);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public <T2, T3, T4> Quadruple<T1, T2, T3, T4> concat(@Nullable T2 val2, @Nullable T3 val3, @Nullable T4 val4) {
        return Quadruple.of(this.val, val2, val3, val4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T2> Tuple<T1, T2> concat(@NotNull Single<T2> val) {
        return Tuple.of(this.val, val.val);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T2, T3> Triple<T1, T2, T3> concat(@NotNull Tuple<T2, T3> val) {
        return Triple.of(this.val, val.left(), val.right());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T2, T3, T4> Quadruple<T1, T2, T3, T4> concat(@NotNull Triple<T2, T3, T4> val) {
        return Quadruple.of(this.val, val.val1(), val.val2(), val.val3());
    }
}

