/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.tuple;

import io.gitlab.jfronny.commons.tuple.Triple;
import io.gitlab.jfronny.commons.tuple.Tuple;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Quadruple<T1, T2, T3, T4>(@Nullable T1 val1, @Nullable T2 val2, @Nullable T3 val3, @Nullable T4 val4) {
    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3, T4> Quadruple<T1, T2, T3, T4> of(@Nullable T1 val1, @Nullable T2 val2, @Nullable T3 val3, @Nullable T4 val4) {
        return new Quadruple<T1, T2, T3, T4>(val1, val2, val3, val4);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3, T4> Quadruple<T1, T2, T3, T4> of(@NotNull Tuple<T1, T2> left, @NotNull Tuple<T3, T4> right) {
        return new Quadruple<T1, T2, T3, T4>(left.left(), left.right(), right.left(), right.right());
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Tuple<T1, Triple<T2, T3, T4>> slice1() {
        return new Tuple<T1, Triple<T2, T3, T4>>(this.val1, new Triple<T2, T3, T4>(this.val2, this.val3, this.val4));
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Tuple<Tuple<T1, T2>, Tuple<T3, T4>> slice2() {
        return new Tuple<Tuple<T1, T2>, Tuple<T3, T4>>(new Tuple<T1, T2>(this.val1, this.val2), new Tuple<T3, T4>(this.val3, this.val4));
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Tuple<Triple<T1, T2, T3>, T4> slice3() {
        return new Tuple<Triple<T1, T2, T3>, T4>(new Triple<T1, T2, T3>(this.val1, this.val2, this.val3), this.val4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Quadruple<T, T2, T3, T4> map1(@NotNull Function<T1, T> mapper) {
        return new Quadruple<T, T2, T3, T4>(Objects.requireNonNull(mapper).apply(this.val1), this.val2, this.val3, this.val4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Quadruple<T1, T, T3, T4> map2(@NotNull Function<T2, T> mapper) {
        return new Quadruple<T1, T, T3, T4>(this.val1, Objects.requireNonNull(mapper).apply(this.val2), this.val3, this.val4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Quadruple<T1, T2, T, T4> map3(@NotNull Function<T3, T> mapper) {
        return new Quadruple<T1, T2, T, T4>(this.val1, this.val2, Objects.requireNonNull(mapper).apply(this.val3), this.val4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Quadruple<T1, T2, T3, T> map4(@NotNull Function<T4, T> mapper) {
        return new Quadruple<T1, T2, T3, T>(this.val1, this.val2, this.val3, Objects.requireNonNull(mapper).apply(this.val4));
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Quadruple<T2, T1, T3, T4> swap12() {
        return new Quadruple<T2, T1, T3, T4>(this.val2, this.val1, this.val3, this.val4);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Quadruple<T3, T2, T1, T4> swap13() {
        return new Quadruple<T3, T2, T1, T4>(this.val3, this.val2, this.val1, this.val4);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Quadruple<T4, T2, T3, T1> swap14() {
        return new Quadruple<T4, T2, T3, T1>(this.val4, this.val2, this.val3, this.val1);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Quadruple<T1, T3, T2, T4> swap23() {
        return new Quadruple<T1, T3, T2, T4>(this.val1, this.val3, this.val2, this.val4);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Quadruple<T1, T4, T3, T2> swap24() {
        return new Quadruple<T1, T4, T3, T2>(this.val1, this.val4, this.val3, this.val2);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Quadruple<T1, T2, T4, T3> swap34() {
        return new Quadruple<T1, T2, T4, T3>(this.val1, this.val2, this.val4, this.val3);
    }
}

