/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.throwable;

import io.gitlab.jfronny.commons.throwable.ThrowingBiConsumer;
import io.gitlab.jfronny.commons.throwable.ThrowingBiFunction;
import io.gitlab.jfronny.commons.throwable.ThrowingConsumer;
import io.gitlab.jfronny.commons.throwable.ThrowingFunction;
import io.gitlab.jfronny.commons.throwable.ThrowingRunnable;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Try {
    public static void orElse(@NotNull ThrowingRunnable<?> tr, @NotNull Consumer<Throwable> alternative) {
        Objects.requireNonNull(tr).addHandler(alternative).run();
    }

    @NotNull
    public static <T> T orElse(@NotNull ThrowingSupplier<T, ?> tr, @NotNull Function<Throwable, ? extends T> alternative) {
        return Objects.requireNonNull(tr).addHandler(alternative).get();
    }

    public static void orThrow(@NotNull ThrowingRunnable<?> tr) {
        Objects.requireNonNull(tr).orThrow().run();
    }

    @NotNull
    public static <T> T orThrow(@NotNull ThrowingSupplier<T, ?> tr) {
        return Objects.requireNonNull(tr).orThrow().get();
    }

    @Contract(pure=true)
    @NotNull
    public static <T, U> BiConsumer<T, U> handle(@NotNull ThrowingBiConsumer<T, U, ?> tr, @NotNull Consumer<Throwable> handler) {
        return Objects.requireNonNull(tr).addHandler(handler);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, U, R> BiFunction<T, U, R> handle(@NotNull ThrowingBiFunction<T, U, R, ?> tr, @NotNull Function<Throwable, ? extends R> handler) {
        return Objects.requireNonNull(tr).addHandler(handler);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Consumer<T> handle(@NotNull ThrowingConsumer<T, ?> tr, @NotNull Consumer<Throwable> handler) {
        return Objects.requireNonNull(tr).addHandler(handler);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, R> Function<T, R> handle(@NotNull ThrowingFunction<T, R, ?> tr, @NotNull Function<Throwable, ? extends R> handler) {
        return Objects.requireNonNull(tr).addHandler(handler);
    }

    @Contract(pure=true)
    @NotNull
    public static Runnable handle(@NotNull ThrowingRunnable<?> tr, @NotNull Consumer<Throwable> handler) {
        return Objects.requireNonNull(tr).addHandler(handler);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> Supplier<T> handle(@NotNull ThrowingSupplier<T, ?> tr, @NotNull Function<Throwable, ? extends T> handler) {
        return Objects.requireNonNull(tr).addHandler(handler);
    }
}

