/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.throwable;

import io.gitlab.jfronny.commons.switchsupport.Result;
import io.gitlab.jfronny.commons.throwable.Coerce;
import io.gitlab.jfronny.commons.throwable.ExceptionWrapper;
import io.gitlab.jfronny.commons.throwable.ThrowingConsumer;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ThrowingFunction<T, R, TEx extends Throwable> {
    @NotNull
    public static <T, R> ThrowingFunction<T, R, RuntimeException> of(@NotNull Function<T, R> function) {
        return Objects.requireNonNull(function)::apply;
    }

    public R apply(T var1) throws TEx;

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingSupplier<R, TEx> compose(@NotNull ThrowingSupplier<? extends T, ? extends TEx> before) {
        Objects.requireNonNull(before);
        return () -> this.apply(before.get());
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <V> ThrowingFunction<V, R, TEx> compose(@NotNull ThrowingFunction<? super V, ? extends T, ? extends TEx> before) {
        Objects.requireNonNull(before);
        return v -> this.apply(before.apply((Object)v));
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <V> ThrowingFunction<T, V, TEx> andThen(@NotNull ThrowingFunction<? super R, ? extends V, ? extends TEx> after) {
        Objects.requireNonNull(after);
        return t -> after.apply((R)this.apply(t));
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <V> ThrowingFunction<T, V, TEx> cast(@Nullable Class<?> type) {
        if (type == null) {
            return v -> this.apply(v);
        }
        return this.andThen(Coerce.cast(type));
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingConsumer<T, TEx> andThen(@NotNull ThrowingConsumer<? super R, ? extends TEx> after) {
        Objects.requireNonNull(after);
        return t -> after.accept((R)this.apply(t));
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public Function<T, R> addHandler(@NotNull Function<Throwable, ? extends R> handler) {
        Objects.requireNonNull(handler);
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Throwable e) {
                return handler.apply(e);
            }
        };
    }

    @Contract(value="_, _ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public Function<T, R> addHandler(@NotNull Class<TEx> exception, @NotNull Function<TEx, ? extends R> handler) {
        Objects.requireNonNull(exception);
        Objects.requireNonNull(handler);
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Throwable e) {
                if (exception.isAssignableFrom(e.getClass())) {
                    return handler.apply(e);
                }
                throw ExceptionWrapper.wrap(e);
            }
        };
    }

    @Contract(value="-> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public Function<T, R> orThrow() {
        return this.orThrow(ExceptionWrapper::wrap)::apply;
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <TEx1 extends Throwable> ThrowingFunction<T, R, TEx1> orThrow(@NotNull Function<Throwable, TEx1> generator) {
        Objects.requireNonNull(generator);
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Throwable e) {
                throw (Throwable)generator.apply(e);
            }
        };
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public Function<T, Result<R, TEx>> toResult(@NotNull Class<TEx> exception) {
        return v -> {
            try {
                return Result.success(this.apply(v));
            }
            catch (Throwable e) {
                if (exception.isAssignableFrom(e.getClass())) {
                    return Result.failure(e);
                }
                throw ExceptionWrapper.wrap(e);
            }
        };
    }

    @Contract(value="-> new", pure=true)
    @ApiStatus.NonExtendable
    default public Function<T, R> assumeSafe() {
        ThrowingFunction function = this;
        return function::apply;
    }
}

