/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.throwable;

import java.util.Objects;

public class ExceptionWrapper
extends RuntimeException {
    public ExceptionWrapper(Throwable e) {
        super(e);
        if (e instanceof RuntimeException) {
            throw new IllegalArgumentException("ExceptionWrapper cannot wrap RuntimeExceptions");
        }
    }

    public static RuntimeException wrap(Throwable t) {
        RuntimeException runtimeException;
        Objects.requireNonNull(t);
        if (t instanceof RuntimeException) {
            RuntimeException r = (RuntimeException)t;
            runtimeException = r;
        } else {
            runtimeException = new ExceptionWrapper(t);
        }
        return runtimeException;
    }

    public static Throwable unwrap(Throwable t) {
        Throwable throwable;
        Objects.requireNonNull(t);
        if (t instanceof ExceptionWrapper) {
            ExceptionWrapper w = (ExceptionWrapper)t;
            throwable = w.getCause();
        } else {
            throwable = t;
        }
        return throwable;
    }
}

