/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.json;

import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.StringEscapeUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class JsonWriter
extends SerializeWriter<IOException, JsonWriter>
implements Closeable {
    private final Writer out;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String newline;
    private String indent;
    private String formattedColon;
    private String formattedComma;
    private boolean usesEmptyNewlineAndIndent;
    private boolean omitQuotes;
    private String deferredName;
    private final List<String> deferredComments;
    private boolean commentUnexpectedNames;
    private boolean customFormatting;

    public JsonWriter(Writer out) {
        this.push(6);
        this.omitQuotes = false;
        this.deferredComments = new LinkedList<String>();
        this.commentUnexpectedNames = false;
        this.customFormatting = false;
        this.out = Objects.requireNonNull(out, "out == null");
        this.indent = "";
        this.newline = "";
        this.setIndent("");
        this.setNewline("");
    }

    public JsonWriter setIndent(String indent) {
        if (indent == null || indent.isEmpty()) {
            this.indent = "";
            if (!this.customFormatting) {
                this.formattedColon = ":";
                this.formattedComma = ",";
            }
            this.usesEmptyNewlineAndIndent = this.newline.isEmpty();
        } else {
            this.indent = indent;
            if (!this.customFormatting) {
                this.newline = "\n";
                this.formattedColon = ": ";
                this.formattedComma = ",";
            }
            this.usesEmptyNewlineAndIndent = false;
        }
        return this;
    }

    public String getIndent() {
        return this.indent;
    }

    public JsonWriter setNewline(String newline) {
        if (newline == null || newline.isEmpty()) {
            this.newline = "";
            if (!this.customFormatting) {
                this.formattedComma = this.indent.isEmpty() ? "," : ", ";
            }
            this.usesEmptyNewlineAndIndent = this.indent.isEmpty();
        } else {
            this.newline = newline;
            if (!this.customFormatting) {
                this.formattedComma = ",";
            }
            this.usesEmptyNewlineAndIndent = false;
        }
        return this;
    }

    public String getNewline() {
        return this.newline;
    }

    public JsonWriter configureFormatting(String indent, String newline, String colon, String comma) {
        this.customFormatting = true;
        this.setIndent(indent);
        this.setNewline(newline);
        this.formattedColon = colon;
        this.formattedComma = comma;
        return this;
    }

    public JsonWriter setOmitQuotes(boolean omitQuotes) {
        this.omitQuotes = omitQuotes;
        return this;
    }

    public boolean isOmitQuotes() {
        return this.omitQuotes;
    }

    public JsonWriter setCommentUnexpectedNames(boolean commentUnexpectedNames) {
        this.commentUnexpectedNames = commentUnexpectedNames;
        return this;
    }

    public boolean isCommentUnexpectedNames() {
        return this.commentUnexpectedNames;
    }

    @Override
    public boolean isStandaloneNames() {
        return this.isCommentUnexpectedNames();
    }

    @Override
    public JsonWriter beginArray() throws IOException {
        this.writeDeferredName();
        return this.openScope(1, '[');
    }

    @Override
    public JsonWriter endArray() throws IOException {
        return this.closeScope(1, 2, ']');
    }

    @Override
    public JsonWriter beginObject() throws IOException {
        this.writeDeferredName();
        return this.openScope(3, '{');
    }

    @Override
    public JsonWriter endObject() throws IOException {
        return this.closeScope(3, 5, '}');
    }

    private JsonWriter openScope(int empty, char openBracket) throws IOException {
        this.beforeValue();
        this.push(empty);
        this.out.write(openBracket);
        return this;
    }

    private JsonWriter closeScope(int empty, int nonempty, char closeBracket) throws IOException {
        int context = this.peek();
        if (context != nonempty && context != empty) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.deferredName != null) {
            if (this.lenient) {
                this.nullValue();
            } else {
                throw new IllegalStateException("Dangling name: " + this.deferredName);
            }
        }
        if (!this.deferredComments.isEmpty()) {
            this.newline();
            this.writeDeferredComment();
            context = nonempty;
        }
        --this.stackSize;
        if (context == nonempty) {
            this.newline();
        }
        this.out.write(closeBracket);
        return this;
    }

    private void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.stackSize * 2);
        }
        this.stack[this.stackSize++] = newTop;
    }

    private int peek() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.stack[this.stackSize - 1];
    }

    private void replaceTop(int topOfStack) {
        this.stack[this.stackSize - 1] = topOfStack;
    }

    @Override
    public JsonWriter comment(String comment) throws IOException {
        if (!this.lenient) {
            throw new MalformedDataException("Cannot write comment in non-lenient JsonWriter.");
        }
        if (comment == null || comment.isBlank()) {
            return this;
        }
        String[] parts = comment.split("\n");
        Collections.addAll(this.deferredComments, parts);
        if (this.peek() == 7) {
            this.newline();
            this.writeDeferredComment();
        }
        return this;
    }

    private void writeDeferredComment() throws IOException {
        if (!this.deferredComments.isEmpty()) {
            if (this.newline.isEmpty()) {
                this.out.append("/* ").append(String.join((CharSequence)" / ", this.deferredComments.stream().filter(s -> s != null && !s.isBlank()).map(s -> s.replace("/*", "#/")).toList())).append(" */");
            } else {
                boolean first = true;
                for (String s2 : this.deferredComments) {
                    if (!first) {
                        this.newline();
                    }
                    first = false;
                    this.out.append("// ").append(s2);
                }
            }
            this.deferredComments.clear();
        }
    }

    @Override
    public JsonWriter name(String name) throws IOException {
        Objects.requireNonNull(name, "name == null");
        if (this.deferredName != null) {
            throw new IllegalStateException("Already wrote a name, expecting a value.");
        }
        int context = this.peek();
        if (context != 3 && context != 5) {
            if (this.lenient) {
                if (context != 1 && context != 2 && context != 6 && context != 7) {
                    throw new IllegalStateException("Please begin an object or array before writing a name.");
                }
            } else {
                throw new IllegalStateException("Please begin an object before writing a name.");
            }
        }
        this.deferredName = name;
        return this;
    }

    private void writeDeferredName() throws IOException {
        if (this.deferredName != null) {
            int context = this.peek();
            if (context == 1 || context == 2 || context == 6 || context == 7) {
                if (this.commentUnexpectedNames) {
                    this.comment(this.deferredName);
                }
            } else {
                this.beforeName();
                if (this.omitQuotes && this.deferredName.matches("[a-zA-Z_$][\\w$]*")) {
                    this.out.write(this.deferredName);
                } else {
                    this.string(this.deferredName);
                }
            }
            this.deferredName = null;
        }
    }

    @Override
    public JsonWriter value(String value) throws IOException {
        if (value == null) {
            return (JsonWriter)this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.string(value);
        return this;
    }

    @Override
    public JsonWriter literalValue(String value) throws IOException {
        if (value == null) {
            return (JsonWriter)this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.append(value);
        return this;
    }

    @Override
    protected IOException createException(String message) {
        return new MalformedDataException(message);
    }

    @Override
    public void flush() throws IOException {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        int size = this.stackSize;
        if (size > 1 || size == 1 && this.stack[size - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.stackSize = 0;
    }

    private void string(String value) throws IOException {
        this.out.write(34);
        int last = 0;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            String replacement = StringEscapeUtil.getReplacement(c);
            if (replacement == null) continue;
            if (last < i) {
                this.out.write(value, last, i - last);
            }
            this.out.write(replacement);
            last = i + 1;
        }
        if (last < length) {
            this.out.write(value, last, length - last);
        }
        this.out.write(34);
    }

    private void newline() throws IOException {
        if (this.usesEmptyNewlineAndIndent) {
            return;
        }
        this.out.write(this.newline);
        int size = this.stackSize;
        for (int i = 1; i < size; ++i) {
            this.out.write(this.indent);
        }
    }

    private void beforeName() throws IOException {
        int context = this.peek();
        if (context == 5) {
            this.out.write(this.formattedComma);
        } else if (context != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.newline();
        if (!this.deferredComments.isEmpty()) {
            this.writeDeferredComment();
            this.newline();
        }
        this.replaceTop(4);
    }

    private void beforeValue() throws IOException {
        switch (this.peek()) {
            case 7: {
                if (!this.lenient) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case 6: {
                this.replaceTop(7);
                if (this.deferredComments.isEmpty()) break;
                this.writeDeferredComment();
                this.newline();
                break;
            }
            case 1: {
                this.replaceTop(2);
                this.newline();
                if (this.deferredComments.isEmpty()) break;
                this.writeDeferredComment();
                this.newline();
                break;
            }
            case 2: {
                this.out.append(this.formattedComma);
                this.newline();
                if (this.deferredComments.isEmpty()) break;
                this.writeDeferredComment();
                this.newline();
                break;
            }
            case 4: {
                this.out.append(this.formattedColon);
                if (!this.deferredComments.isEmpty()) {
                    this.newline();
                    this.writeDeferredComment();
                    this.newline();
                }
                this.replaceTop(5);
                break;
            }
            default: {
                throw new IllegalStateException("Nesting problem.");
            }
        }
    }
}

