/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.emulated;

import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import java.util.Arrays;

public class WriterItemView<TEx extends Exception>
extends SerializeWriter.Delegating<TEx, WriterItemView<TEx>> {
    private boolean[] stack = new boolean[4];
    private int depth = 0;
    private boolean began = false;

    public WriterItemView(SerializeWriter<TEx, ?> delegate) {
        super(delegate);
    }

    private void validateLegalBegin() throws TEx {
        if (!this.began) {
            this.began = true;
        } else if (this.depth == 0) {
            throw this.createException("View already exhausted");
        }
    }

    private void validateLegalEnd() throws TEx {
        if (!this.began) {
            throw this.createException("View not yet begun");
        }
        if (this.depth == 0) {
            throw this.createException("View already exhausted");
        }
    }

    private void push(boolean value) {
        if (this.depth == this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.stack.length * 2);
        }
        this.stack[this.depth++] = value;
    }

    @Override
    public WriterItemView<TEx> beginArray() throws TEx {
        this.validateLegalBegin();
        this.delegate.beginArray();
        this.began = true;
        this.push(true);
        return this;
    }

    @Override
    public WriterItemView<TEx> endArray() throws TEx {
        this.validateLegalEnd();
        this.delegate.endArray();
        --this.depth;
        return this;
    }

    @Override
    public WriterItemView<TEx> beginObject() throws TEx {
        this.validateLegalBegin();
        this.delegate.beginObject();
        this.began = true;
        this.push(false);
        return this;
    }

    @Override
    public WriterItemView<TEx> endObject() throws TEx {
        this.validateLegalEnd();
        this.delegate.endObject();
        --this.depth;
        return this;
    }

    @Override
    public WriterItemView<TEx> comment(String comment) throws TEx {
        this.validateLegalBegin();
        this.delegate.comment(comment);
        return this;
    }

    @Override
    public WriterItemView<TEx> name(String name) throws TEx {
        this.validateLegalBegin();
        this.delegate.name(name);
        return this;
    }

    @Override
    public WriterItemView<TEx> value(String value) throws TEx {
        this.validateLegalBegin();
        this.delegate.value(value);
        this.began = true;
        return this;
    }

    @Override
    public WriterItemView<TEx> literalValue(String value) throws TEx {
        this.validateLegalBegin();
        this.delegate.literalValue(value);
        this.began = true;
        return this;
    }

    @Override
    public WriterItemView<TEx> nullValue() throws TEx {
        this.validateLegalBegin();
        this.delegate.nullValue();
        this.began = true;
        return this;
    }

    @Override
    public WriterItemView<TEx> value(boolean value) throws TEx {
        this.validateLegalBegin();
        this.delegate.value(value);
        this.began = true;
        return this;
    }

    @Override
    public WriterItemView<TEx> value(float value) throws TEx {
        this.validateLegalBegin();
        this.delegate.value(value);
        this.began = true;
        return this;
    }

    @Override
    public WriterItemView<TEx> value(double value) throws TEx {
        this.validateLegalBegin();
        this.delegate.value(value);
        this.began = true;
        return this;
    }

    @Override
    public WriterItemView<TEx> value(long value) throws TEx {
        this.validateLegalBegin();
        this.delegate.value(value);
        this.began = true;
        return this;
    }

    @Override
    public WriterItemView<TEx> value(Number value) throws TEx {
        this.validateLegalBegin();
        this.delegate.value(value);
        this.began = true;
        return this;
    }

    @Override
    public void close() throws TEx {
        if (!this.began) {
            this.delegate.nullValue();
            return;
        }
        while (this.depth > 0) {
            if (this.stack[--this.depth]) {
                this.delegate.endArray();
                continue;
            }
            this.delegate.endObject();
        }
    }
}

