/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.emulated;

import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.Token;
import io.gitlab.jfronny.commons.serialize.emulated.DataElement;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataElementSerializer {
    public static <TEx extends Exception, T extends SerializeWriter<TEx, ?>> void serialize(DataElement element, T out) throws TEx {
        DataElement dataElement = element;
        Objects.requireNonNull(dataElement);
        DataElement dataElement2 = dataElement;
        int n = 0;
        block5 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataElement.Array.class, DataElement.Null.class, DataElement.Object.class, DataElement.Primitive.class}, (Object)dataElement2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                List<DataElement> list;
                DataElement.Array array = (DataElement.Array)dataElement2;
                List<DataElement> elements = list = array.elements();
                out.array(b -> {
                    for (DataElement e : elements) {
                        DataElementSerializer.serialize(e, b);
                    }
                    return b;
                });
                break;
            }
            case 1: {
                DataElement.Null n2 = (DataElement.Null)dataElement2;
                out.nullValue();
                break;
            }
            case 2: {
                Map<String, DataElement> map;
                DataElement.Object object = (DataElement.Object)dataElement2;
                Map<String, DataElement> members = map = object.members();
                out.object(b -> {
                    for (Map.Entry e : members.entrySet()) {
                        b.name((String)e.getKey());
                        DataElementSerializer.serialize((DataElement)e.getValue(), b);
                    }
                    return b;
                });
                break;
            }
            case 3: {
                String value;
                DataElement.Primitive p;
                DataElement.Primitive primitive = p = (DataElement.Primitive)dataElement2;
                Objects.requireNonNull(primitive);
                DataElement.Primitive primitive2 = primitive;
                int n3 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataElement.Primitive.Boolean.class, DataElement.Primitive.Number.class, DataElement.Primitive.String.class}, (Object)primitive2, n3)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        boolean bl;
                        DataElement.Primitive.Boolean boolean_ = (DataElement.Primitive.Boolean)primitive2;
                        boolean value2 = bl = boolean_.value();
                        out.value(value2);
                        break block5;
                    }
                    case 1: {
                        Number number;
                        DataElement.Primitive.Number number2 = (DataElement.Primitive.Number)primitive2;
                        Number value3 = number = number2.value();
                        out.value(value3);
                        break block5;
                    }
                    case 2: 
                }
                DataElement.Primitive.String string = (DataElement.Primitive.String)primitive2;
                try {
                    String string2;
                    value = string2 = string.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                out.value(value);
                break;
            }
        }
    }

    public static <TEx extends Exception, T extends SerializeReader<TEx, ?>> DataElement deserialize(T in) throws TEx {
        return switch (in.peek()) {
            default -> throw new MatchException(null, null);
            case Token.STRING -> new DataElement.Primitive.String(in.nextString());
            case Token.NUMBER -> new DataElement.Primitive.Number(in.nextNumber());
            case Token.BOOLEAN -> new DataElement.Primitive.Boolean(in.nextBoolean());
            case Token.NULL -> {
                in.nextNull();
                yield new DataElement.Null();
            }
            case Token.BEGIN_ARRAY -> in.array(b -> {
                DataElement.Array array = new DataElement.Array();
                while (b.hasNext()) {
                    array.elements().add(DataElementSerializer.deserialize(b));
                }
                return array;
            });
            case Token.BEGIN_OBJECT -> in.object(b -> {
                DataElement.Object object = new DataElement.Object();
                while (b.hasNext()) {
                    object.members().put(b.nextName(), DataElementSerializer.deserialize(b));
                }
                return object;
            });
            case Token.END_ARRAY, Token.END_OBJECT, Token.END_DOCUMENT, Token.NAME -> throw new IllegalStateException();
        };
    }
}

