/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.emulated;

import io.gitlab.jfronny.commons.data.LinkedTreeMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public sealed interface DataElement {

    public record Array(List<DataElement> elements) implements DataElement
    {
        public Array() {
            this(new ArrayList<DataElement>());
        }
    }

    public record Object(Map<String, DataElement> members) implements DataElement
    {
        public Object() {
            this(new LinkedTreeMap<String, DataElement>(false));
        }
    }

    public static sealed interface Primitive
    extends DataElement {
        public java.lang.String asString();

        public record String(java.lang.String value) implements Primitive
        {
            @Override
            public java.lang.String asString() {
                return this.value;
            }
        }

        public record Number(java.lang.Number value) implements Primitive
        {
            public Number {
                Objects.requireNonNull(value);
            }

            @Override
            public java.lang.String asString() {
                return this.value.toString();
            }
        }

        public record Boolean(boolean value) implements Primitive
        {
            @Override
            public java.lang.String asString() {
                return this.value ? "true" : "false";
            }
        }
    }

    public record Null() implements DataElement
    {
    }
}

