/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.databind.impl.adapter;

import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.databind.ObjectMapper;
import io.gitlab.jfronny.commons.serialize.databind.TypeAdapterFactory;
import io.gitlab.jfronny.commons.serialize.databind.api.SerializeWithAdapter;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeAdapter;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeToken;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeUtils;
import io.gitlab.jfronny.commons.throwable.Coerce;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import java.util.Objects;

public class SerializationAdapterTypeAdapterFactory
implements TypeAdapterFactory {
    @Override
    public <T> TypeAdapter<T> create(ObjectMapper mapper, TypeToken<T> type) {
        ThrowingSupplier<TypeAdapter<Object>, MalformedDataException> result;
        SerializeWithAdapter adapter = type.getRawType().getAnnotation(SerializeWithAdapter.class);
        if (adapter == null) {
            return null;
        }
        if (TypeAdapterFactory.class.isAssignableFrom(adapter.adapter())) {
            result = Objects.requireNonNull(TypeUtils.constructor(TypeToken.get(adapter.adapter())), "Specified adapter has no public no-args constructor").andThen(Coerce.function(factory -> factory.create(mapper, type)));
        } else if (TypeAdapter.class.isAssignableFrom(adapter.adapter())) {
            result = Objects.requireNonNull(TypeUtils.constructor(TypeToken.get(adapter.adapter())), "Specified adapter has no public no-args constructor");
        } else {
            return null;
        }
        try {
            return adapter.nullSafe() ? result.get().nullSafe() : result.get();
        }
        catch (MalformedDataException e) {
            throw new RuntimeException(e);
        }
    }
}

