/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.databind.impl.adapter;

import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.annotations.SerializedName;
import io.gitlab.jfronny.commons.serialize.databind.ObjectMapper;
import io.gitlab.jfronny.commons.serialize.databind.TypeAdapterFactory;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeAdapter;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeToken;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class EnumTypeAdapterFactory
implements TypeAdapterFactory {
    @Override
    public <T> TypeAdapter<T> create(ObjectMapper mapper, TypeToken<T> type) {
        Class<T> rawRype = type.getRawType();
        if (!Enum.class.isAssignableFrom(rawRype) || rawRype == Enum.class) {
            return null;
        }
        if (!rawRype.isEnum()) {
            rawRype = rawRype.getSuperclass();
        }
        return new EnumTypeAdapter<T>(rawRype);
    }

    private static class EnumTypeAdapter<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Map<String, T> nameToConstant = new HashMap<String, T>();
        private final Map<String, T> stringToConstant = new HashMap<String, T>();
        private final Map<T, String> constantToName = new HashMap<T, String>();

        public EnumTypeAdapter(Class<T> classOfT) {
            try {
                Field[] fields = classOfT.getDeclaredFields();
                ArrayList<Field> constantFieldsList = new ArrayList<Field>(fields.length);
                for (Field f : fields) {
                    if (!f.isEnumConstant()) continue;
                    constantFieldsList.add(f);
                }
                AccessibleObject[] constantFields = constantFieldsList.toArray(new Field[0]);
                AccessibleObject.setAccessible(constantFields, true);
                for (AccessibleObject constantField : constantFields) {
                    Enum constant = (Enum)((Field)constantField).get(null);
                    String name = constant.name();
                    String toStringVal = constant.toString();
                    SerializedName annotation = ((Field)constantField).getAnnotation(SerializedName.class);
                    if (annotation != null) {
                        name = annotation.value();
                        for (String alternate : annotation.alternate()) {
                            this.nameToConstant.put(alternate, constant);
                        }
                    }
                    this.nameToConstant.put(name, constant);
                    this.stringToConstant.put(toStringVal, constant);
                    this.constantToName.put(constant, name);
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(T value, Writer writer) throws TEx, MalformedDataException {
            writer.value(value == null ? null : this.constantToName.get(value));
        }

        @Override
        public <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> T deserialize(Reader reader) throws TEx, MalformedDataException {
            String key = reader.nextString();
            Enum constant = (Enum)this.nameToConstant.get(key);
            return (T)(constant == null ? (Enum)this.stringToConstant.get(key) : constant);
        }
    }
}

