/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.databind.impl.adapter;

import io.gitlab.jfronny.commons.serialize.ISO8601Utils;
import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.databind.api.SerializerFor;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeAdapter;
import io.gitlab.jfronny.commons.serialize.databind.impl.PreJava9DateFormatProvider;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

@SerializerFor(targets={Date.class})
public class DefaultDateTypeAdapter
extends TypeAdapter<Date> {
    private static final String SIMPLE_NAME = "DefaultDateTypeAdapter";
    private final List<DateFormat> dateFormats = new ArrayList<DateFormat>();

    public DefaultDateTypeAdapter() {
        this.dateFormats.add(DateFormat.getDateTimeInstance(2, 2, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.dateFormats.add(DateFormat.getDateTimeInstance(2, 2));
        }
        this.dateFormats.add(PreJava9DateFormatProvider.getUsDateTimeFormat(2, 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(Date value, Writer writer) throws TEx, MalformedDataException {
        String dateFormatAsString;
        DateFormat dateFormat = this.dateFormats.getFirst();
        List<DateFormat> list = this.dateFormats;
        synchronized (list) {
            dateFormatAsString = dateFormat.format(value);
        }
        writer.value(dateFormatAsString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> Date deserialize(Reader reader) throws TEx, MalformedDataException {
        String s = reader.nextString();
        List<DateFormat> list = this.dateFormats;
        synchronized (list) {
            for (DateFormat dateFormat : this.dateFormats) {
                TimeZone originalTimeZone = dateFormat.getTimeZone();
                try {
                    Date date = dateFormat.parse(s);
                    return date;
                }
                catch (ParseException parseException) {}
                continue;
                finally {
                    dateFormat.setTimeZone(originalTimeZone);
                }
            }
        }
        try {
            return ISO8601Utils.parse(s, new ParsePosition(0));
        }
        catch (ParseException e) {
            throw new MalformedDataException("Failed parsing '" + s + "' as Date; at path " + reader.getPreviousPath(), e);
        }
    }

    public String toString() {
        DateFormat defaultFormat = this.dateFormats.getFirst();
        if (defaultFormat instanceof SimpleDateFormat) {
            return "DefaultDateTypeAdapter(" + ((SimpleDateFormat)defaultFormat).toPattern() + ")";
        }
        return "DefaultDateTypeAdapter(" + defaultFormat.getClass().getSimpleName() + ")";
    }
}

