/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.databind.api.impl;

import io.gitlab.jfronny.commons.data.LinkedTreeMap;
import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeToken;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class ConstructorConstructor {
    public static <T> ThrowingSupplier<T, MalformedDataException> get(TypeToken<T> typeToken) {
        Class<T> rawType;
        Type type = typeToken.getType();
        ThrowingSupplier<T, MalformedDataException> specialConstructor = ConstructorConstructor.newSpecialCollectionConstructor(type, rawType = typeToken.getRawType());
        if (specialConstructor != null) {
            return specialConstructor;
        }
        ThrowingSupplier<T, MalformedDataException> defaultConstructor = ConstructorConstructor.newDefaultConstructor(rawType);
        if (defaultConstructor != null) {
            return defaultConstructor;
        }
        ThrowingSupplier<T, MalformedDataException> defaultImplementation = ConstructorConstructor.newDefaultImplementationConstructor(type, rawType);
        if (defaultImplementation != null) {
            return defaultImplementation;
        }
        return Modifier.isInterface(rawType.getModifiers()) || Modifier.isAbstract(rawType.getModifiers()) ? ConstructorConstructor.fail("Cannot instantiate abstract class or interface: " + String.valueOf(rawType)) : ConstructorConstructor.fail("Class lacks viable constructor: " + String.valueOf(rawType));
    }

    private static <T> ThrowingSupplier<T, MalformedDataException> newSpecialCollectionConstructor(Type type, Class<? super T> rawType) {
        if (EnumSet.class.isAssignableFrom(rawType)) {
            return () -> {
                if (type instanceof ParameterizedType) {
                    Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
                    if (elementType instanceof Class) {
                        EnumSet set = EnumSet.noneOf((Class)elementType);
                        return set;
                    }
                    throw new MalformedDataException("Invalid EnumSet type: " + String.valueOf(type));
                }
                throw new MalformedDataException("Invalid EnumSet type: " + String.valueOf(type));
            };
        }
        if (rawType == EnumMap.class) {
            return () -> {
                if (type instanceof ParameterizedType) {
                    Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
                    if (elementType instanceof Class) {
                        EnumMap map = new EnumMap((Class)elementType);
                        return map;
                    }
                    throw new MalformedDataException("Invalid EnumMap type: " + String.valueOf(type));
                }
                throw new MalformedDataException("Invalid EnumMap type: " + String.valueOf(type));
            };
        }
        return null;
    }

    private static <T> ThrowingSupplier<T, MalformedDataException> newDefaultConstructor(Class<? super T> rawType) {
        Constructor constructor;
        if (Modifier.isAbstract(rawType.getModifiers())) {
            return null;
        }
        try {
            constructor = rawType.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            return ConstructorConstructor.fail("Unable to invoke no-args constructor of " + String.valueOf(rawType) + ": no public no-args constructor");
        }
        return () -> {
            try {
                Object newInstance = constructor.newInstance(new Object[0]);
                return newInstance;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new MalformedDataException("Failed to invoke no-args constructor for " + String.valueOf(rawType), e);
            }
        };
    }

    private static <T> ThrowingSupplier<T, MalformedDataException> newDefaultImplementationConstructor(Type type, Class<? super T> rawType) {
        if (Collection.class.isAssignableFrom(rawType)) {
            if (SortedSet.class.isAssignableFrom(rawType)) {
                return ConstructorConstructor.coerce(TreeSet::new, rawType);
            }
            if (Set.class.isAssignableFrom(rawType)) {
                return ConstructorConstructor.coerce(LinkedHashSet::new, rawType);
            }
            if (Queue.class.isAssignableFrom(rawType)) {
                return ConstructorConstructor.coerce(ArrayDeque::new, rawType);
            }
            return ConstructorConstructor.coerce(ArrayList::new, rawType);
        }
        if (Map.class.isAssignableFrom(rawType)) {
            if (ConcurrentNavigableMap.class.isAssignableFrom(rawType)) {
                return ConstructorConstructor.coerce(ConcurrentSkipListMap::new, rawType);
            }
            if (ConcurrentMap.class.isAssignableFrom(rawType)) {
                return ConstructorConstructor.coerce(ConcurrentHashMap::new, rawType);
            }
            if (SortedMap.class.isAssignableFrom(rawType)) {
                return ConstructorConstructor.coerce(TreeMap::new, rawType);
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(TypeToken.get(((ParameterizedType)type).getActualTypeArguments()[0]).getRawType())) {
                return ConstructorConstructor.coerce(LinkedHashMap::new, rawType);
            }
            return ConstructorConstructor.coerce(LinkedTreeMap::new, rawType);
        }
        return null;
    }

    private static <T> ThrowingSupplier<T, MalformedDataException> coerce(ThrowingSupplier<?, MalformedDataException> supplier, Class<? super T> rawType) {
        return supplier.cast(rawType);
    }

    private static <T> ThrowingSupplier<T, MalformedDataException> fail(String message) {
        return () -> {
            throw new MalformedDataException(message);
        };
    }
}

