/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.databind;

import io.gitlab.jfronny.commons.concurrent.ScopedValue;
import io.gitlab.jfronny.commons.concurrent.WithScopedValue;
import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.databind.SerializationDelegatingTypeAdapter;
import io.gitlab.jfronny.commons.serialize.databind.TypeAdapterFactory;
import io.gitlab.jfronny.commons.serialize.databind.api.SerializerFor;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeAdapter;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeToken;
import io.gitlab.jfronny.commons.serialize.databind.impl.HierarchyAdapter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ObjectMapper
implements WithScopedValue<ObjectMapper> {
    public static final ScopedValue<ObjectMapper> CURRENT = ScopedValue.newInstance();
    private final ThreadLocal<Map<TypeToken<?>, TypeAdapter<?>>> threadLocalAdapterResults = new ThreadLocal();
    private final ConcurrentMap<TypeToken<?>, TypeAdapter<?>> typeTokenCache = new ConcurrentHashMap();
    private final List<TypeAdapterFactory> factories = new ArrayList<TypeAdapterFactory>();
    private final Map<TypeToken<?>, TypeAdapter<?>> explicitAdapters = new ConcurrentHashMap();
    private final Map<TypeToken<?>, TypeAdapter<?>> hierarchyAdapters = new ConcurrentHashMap();

    public ObjectMapper() {
        ServiceLoader.load(TypeAdapterFactory.class).forEach(this::registerTypeAdapterFactory);
        ServiceLoader.load(TypeAdapter.class).forEach(this::registerTypeAdapter);
    }

    public ObjectMapper registerTypeAdapter(Type type, TypeAdapter<?> adapter, boolean hierarchical) {
        (hierarchical ? this.hierarchyAdapters : this.explicitAdapters).put(TypeToken.get(type), Objects.requireNonNull(adapter));
        return this;
    }

    public ObjectMapper registerTypeAdapter(TypeAdapter<?> adapter) {
        SerializerFor annotation = adapter.getClass().getAnnotation(SerializerFor.class);
        if (annotation == null) {
            throw new IllegalArgumentException("TypeAdapter must be annotated with @SerializerFor to register it without specifying the target type: " + adapter.getClass().getName());
        }
        adapter = annotation.nullSafe() ? adapter.nullSafe() : adapter;
        for (Class<?> target : annotation.targets()) {
            this.registerTypeAdapter(target, adapter, annotation.hierarchical());
        }
        return this;
    }

    public ObjectMapper registerTypeAdapterFactory(TypeAdapterFactory factory) {
        this.factories.addFirst(Objects.requireNonNull(factory));
        return this;
    }

    public <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, T> T deserialize(Class<T> type, Reader reader) throws TEx, MalformedDataException {
        return (T)this.withContext(() -> this.getAdapter(type).deserialize(reader));
    }

    public <TEx extends Exception, Writer extends SerializeWriter<TEx, Writer>, T> void serialize(T value, Writer writer) throws TEx, MalformedDataException {
        this.withContext(() -> this.getAdapter(value.getClass()).serialize(value, writer));
    }

    public <T> TypeAdapter<T> getAdapter(Class<T> type) {
        return this.getAdapter(TypeToken.get(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public <T> TypeAdapter<T> getAdapter(TypeToken<T> type) {
        void var3_6;
        Objects.requireNonNull(type, "type must not be null");
        if (this.explicitAdapters.containsKey(type)) {
            return this.explicitAdapters.get(type);
        }
        for (TypeToken<T> typeToken : this.hierarchyAdapters.keySet()) {
            if (!typeToken.isAssignableFrom(type)) continue;
            HierarchyAdapter adapter = new HierarchyAdapter(this.hierarchyAdapters.get(typeToken), type.getRawType());
            this.explicitAdapters.put(type, adapter);
            return adapter;
        }
        TypeAdapter cached = (TypeAdapter)this.typeTokenCache.get(type);
        if (cached != null) {
            return cached;
        }
        Map<TypeToken<?>, TypeAdapter<?>> map = this.threadLocalAdapterResults.get();
        boolean isInitialAdapterRequest = false;
        if (map == null) {
            HashMap hashMap = new HashMap();
            this.threadLocalAdapterResults.set(hashMap);
            isInitialAdapterRequest = true;
        } else {
            TypeAdapter<?> ongoingCall = map.get(type);
            if (ongoingCall != null) {
                return ongoingCall;
            }
        }
        TypeAdapter<T> candidate = null;
        try {
            FutureTypeAdapter<T> call = new FutureTypeAdapter<T>();
            var3_6.put(type, call);
            for (TypeAdapterFactory factory : this.factories) {
                candidate = factory.create(this, type);
                if (candidate == null) continue;
                call.setDelegate(candidate);
                var3_6.put(type, candidate);
                break;
            }
        }
        finally {
            if (isInitialAdapterRequest) {
                this.threadLocalAdapterResults.remove();
            }
        }
        if (candidate == null) {
            throw new IllegalArgumentException("JfCommons ObjectMapper cannot handle " + String.valueOf(type));
        }
        if (isInitialAdapterRequest) {
            this.typeTokenCache.putAll((Map<TypeToken<?>, TypeAdapter<?>>)var3_6);
        }
        return candidate;
    }

    @Override
    public ScopedValue<ObjectMapper> getAttached() {
        return CURRENT;
    }

    @Override
    public ObjectMapper self() {
        return this;
    }

    static class FutureTypeAdapter<T>
    extends SerializationDelegatingTypeAdapter<T> {
        private TypeAdapter<T> delegate = null;

        FutureTypeAdapter() {
        }

        public void setDelegate(TypeAdapter<T> typeAdapter) {
            if (this.delegate != null) {
                throw new AssertionError((Object)"Delegate is already set");
            }
            this.delegate = typeAdapter;
        }

        private TypeAdapter<T> delegate() {
            TypeAdapter<T> delegate = this.delegate;
            if (delegate == null) {
                throw new IllegalStateException("Adapter for type with cyclic dependency has been used before dependency has been resolved");
            }
            return delegate;
        }

        @Override
        public TypeAdapter<T> getSerializationDelegate() {
            return this.delegate();
        }

        @Override
        public <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> T deserialize(Reader reader) throws TEx, MalformedDataException {
            return this.delegate().deserialize(reader);
        }

        @Override
        public <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(T value, Writer writer) throws TEx, MalformedDataException {
            this.delegate().serialize(value, writer);
        }
    }
}

