/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize;

import io.gitlab.jfronny.commons.concurrent.ScopedValue;
import io.gitlab.jfronny.commons.concurrent.WithScopedValue;
import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.jetbrains.annotations.ApiStatus;

public interface Transport<TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>>
extends WithScopedValue<Transport<?, ?, ?>> {
    public static final ScopedValue<Transport<?, ?, ?>> DEFAULT = ScopedValue.newInstance();

    @Override
    @ApiStatus.Internal
    default public ScopedValue<Transport<?, ?, ?>> getAttached() {
        return DEFAULT;
    }

    @Override
    @ApiStatus.Internal
    default public Transport<?, ?, ?> self() {
        return this;
    }

    public Reader createReader(Reader var1) throws TEx;

    default public Reader createReader(String source) throws TEx {
        return this.createReader(new StringReader(source));
    }

    public Writer createWriter(Writer var1) throws TEx;

    public String getFormatMime();

    default public void read(Reader source, Action<Reader, TEx> action) throws TEx, MalformedDataException {
        try (Reader reader = this.createReader(source);){
            action.run(reader);
        }
    }

    default public void read(String source, Action<Reader, TEx> action) throws TEx, MalformedDataException {
        this.read((Reader)new StringReader(source), action);
    }

    default public <R> R read(Reader source, Returnable<Reader, R, TEx> action) throws TEx, MalformedDataException {
        try (Reader reader = this.createReader(source);){
            R r = action.run(reader);
            return r;
        }
    }

    default public <R> R read(String source, Returnable<Reader, R, TEx> action) throws TEx, MalformedDataException {
        return this.read((Reader)new StringReader(source), action);
    }

    default public void write(Writer target, Action<Writer, TEx> action) throws TEx, MalformedDataException {
        try (Writer writer = this.createWriter(target);){
            action.run(writer);
        }
    }

    default public String write(Action<Writer, TEx> action) throws TEx, IOException {
        try (StringWriter sw = new StringWriter();){
            this.write(sw, action);
            String string = sw.toString();
            return string;
        }
    }

    public static interface Action<T, TEx extends Exception> {
        public void run(T var1) throws TEx, MalformedDataException;
    }

    public static interface Returnable<T, R, TEx extends Exception> {
        public R run(T var1) throws TEx, MalformedDataException;
    }
}

