/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.ref;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeakValueMap<K, V>
implements Map<K, V> {
    private final ReferenceQueue<V> queue = new ReferenceQueue();
    private final HashMap<K, WeakValue<K, V>> delegate = new HashMap();
    private final EntrySet entrySet = new EntrySet();
    private final ValueCollection values = new ValueCollection();

    @Override
    public synchronized int size() {
        this.processQueue();
        return this.delegate.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        this.processQueue();
        return this.delegate.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(Object o) {
        this.processQueue();
        return this.delegate.containsKey(o);
    }

    @Override
    public synchronized boolean containsValue(Object o) {
        return this.delegate.containsValue(WeakValue.create(o));
    }

    @Override
    public synchronized V get(Object o) {
        return (V)WeakValueMap.unwrap((Reference)this.delegate.get(o));
    }

    @Override
    @Nullable
    public synchronized V put(K k, V v) {
        this.processQueue();
        return (V)WeakValueMap.unwrap((Reference)this.delegate.put(k, WeakValue.create(k, v, this.queue)));
    }

    @Override
    public synchronized V remove(Object o) {
        return (V)WeakValueMap.unwrap((Reference)this.delegate.remove(o));
    }

    @Override
    public synchronized void putAll(@NotNull Map<? extends K, ? extends V> map) {
        this.processQueue();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.delegate.put(entry.getKey(), WeakValue.create(entry.getKey(), entry.getValue(), this.queue));
        }
    }

    @Override
    public synchronized void clear() {
        this.delegate.clear();
    }

    @Override
    @NotNull
    public synchronized Set<K> keySet() {
        this.processQueue();
        return this.delegate.keySet();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.values;
    }

    @Nullable
    private static <T> T unwrap(@Nullable Reference<T> ref) {
        return ref == null ? null : (T)ref.get();
    }

    public void processQueue() {
        WeakValue ref;
        while ((ref = (WeakValue)this.queue.poll()) != null) {
            this.delegate.remove(ref.key);
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            WeakValueMap.this.processQueue();
            return new Iterator<Map.Entry<K, V>>(){
                final Iterator<Map.Entry<K, WeakValue<K, V>>> delegate;
                Map.Entry<K, V> next;
                {
                    this.delegate = WeakValueMap.this.delegate.entrySet().iterator();
                    this.next = null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean hasNext() {
                    WeakValueMap weakValueMap = WeakValueMap.this;
                    synchronized (weakValueMap) {
                        if (this.delegate.hasNext()) {
                            Map.Entry ent = this.delegate.next();
                            Object value = WeakValueMap.unwrap(ent.getValue());
                            if (value == null) {
                                return this.hasNext();
                            }
                            this.next = new DelegateEntry(ent, value);
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Map.Entry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.delegate.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return WeakValueMap.this.isEmpty();
        }

        @Override
        public int size() {
            return WeakValueMap.this.size();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return WeakValueMap.this.remove(e.getKey(), e.getValue());
        }
    }

    private class ValueCollection
    extends AbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        @NotNull
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                final Iterator<Map.Entry<K, V>> delegate;
                {
                    this.delegate = WeakValueMap.this.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.delegate.hasNext();
                }

                @Override
                public V next() {
                    return this.delegate.next().getValue();
                }

                @Override
                public void remove() {
                    this.delegate.remove();
                }
            };
        }

        @Override
        public int size() {
            return WeakValueMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return WeakValueMap.this.containsValue(o);
        }
    }

    private static class WeakValue<K, V>
    extends WeakReference<V> {
        private K key;

        private WeakValue(V value) {
            super(value);
        }

        private WeakValue(K key, V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this.key = key;
        }

        private static <K, V> WeakValue<K, V> create(V value) {
            if (value == null) {
                return null;
            }
            return new WeakValue<K, V>(value);
        }

        private static <K, V> WeakValue<K, V> create(K key, V value, ReferenceQueue<V> queue) {
            if (value == null) {
                return null;
            }
            return new WeakValue<K, V>(key, value, queue);
        }

        public int hashCode() {
            Object ref = this.get();
            return ref == null ? 0 : ref.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WeakValue)) {
                return false;
            }
            WeakValue v = (WeakValue)obj;
            return Objects.equals(this.get(), v.get());
        }

        public String toString() {
            return Objects.toString(this.get());
        }
    }

    private class DelegateEntry
    implements Map.Entry<K, V> {
        private final Map.Entry<K, WeakValue<K, V>> ent;
        private V value;

        DelegateEntry(Map.Entry<K, WeakValue<K, V>> ent, V value) {
            this.ent = ent;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.ent.getKey();
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(Object o) {
            Object oldValue = this.value;
            this.value = o;
            this.ent.setValue(WeakValue.create(this.getKey(), this.value, WeakValueMap.this.queue));
            return oldValue;
        }

        @Override
        public int hashCode() {
            Object k = this.ent.getKey();
            return (k == null ? 0 : k.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)obj;
            return Objects.equals(this.getKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue());
        }
    }
}

