/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.logger.impl;

import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import io.gitlab.jfronny.commons.logger.impl.Formatter;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.ResourceBundle;

public record DelegateLoggerPlus(System.Logger delegate) implements SystemLoggerPlus
{
    public DelegateLoggerPlus {
        Objects.requireNonNull(delegate);
    }

    public static SystemLoggerPlus get(System.Logger delegate) {
        SystemLoggerPlus systemLoggerPlus;
        if (delegate instanceof SystemLoggerPlus) {
            SystemLoggerPlus slp = (SystemLoggerPlus)delegate;
            systemLoggerPlus = slp;
        } else {
            systemLoggerPlus = new DelegateLoggerPlus(delegate);
        }
        return systemLoggerPlus;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public boolean isLoggable(System.Logger.Level level) {
        return this.delegate.isLoggable(level);
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
        this.delegate.log(level, bundle, msg, thrown);
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
        this.delegate.log(level, bundle, format, params);
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String format, Throwable t, Object ... params) {
        System.Logger logger = this.delegate;
        Objects.requireNonNull(logger);
        System.Logger logger2 = logger;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SystemLoggerPlus.class, System.Logger.class}, (Object)logger2, n)) {
            case 0: {
                SystemLoggerPlus slp = (SystemLoggerPlus)logger2;
                slp.log(level, format, t, params);
                break;
            }
            default: {
                System.Logger sl = logger2;
                sl.log(level, Formatter.format(bundle, format, params), t);
            }
        }
    }
}

