/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.logger;

import io.gitlab.jfronny.commons.logger.impl.DelegateLoggerPlus;
import io.gitlab.jfronny.commons.logger.impl.Formatter;
import io.gitlab.jfronny.commons.logger.impl.LoggingPrintStream;
import java.util.ResourceBundle;

public interface SystemLoggerPlus
extends System.Logger {
    public static SystemLoggerPlus forName(String name) {
        return SystemLoggerPlus.get(System.getLogger(name));
    }

    public static SystemLoggerPlus get(System.Logger logger) {
        return DelegateLoggerPlus.get(logger);
    }

    default public void log(System.Logger.Level level, ResourceBundle bundle, String format, Throwable t, Object ... params) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.log(level, Formatter.format(bundle, format, params), t);
    }

    default public void log(System.Logger.Level level, String format, Throwable t, Object ... params) {
        this.log(level, null, format, t, params);
    }

    default public void trace(String msg, Object ... params) {
        this.log(System.Logger.Level.TRACE, msg, params);
    }

    default public void trace(String msg, Throwable t) {
        this.log(System.Logger.Level.TRACE, msg, t);
    }

    default public void trace(String msg, Throwable t, Object ... params) {
        this.log(System.Logger.Level.TRACE, msg, t, params);
    }

    default public void debug(String msg, Object ... params) {
        this.log(System.Logger.Level.DEBUG, msg, params);
    }

    default public void debug(String msg, Throwable t) {
        this.log(System.Logger.Level.DEBUG, msg, t);
    }

    default public void debug(String msg, Throwable t, Object ... params) {
        this.log(System.Logger.Level.DEBUG, msg, t, params);
    }

    default public void info(String msg, Object ... params) {
        this.log(System.Logger.Level.INFO, msg, params);
    }

    default public void info(String msg, Throwable t) {
        this.log(System.Logger.Level.INFO, msg, t);
    }

    default public void info(String msg, Throwable t, Object ... params) {
        this.log(System.Logger.Level.INFO, msg, t, params);
    }

    default public void warn(String msg, Object ... params) {
        this.log(System.Logger.Level.WARNING, msg, params);
    }

    default public void warn(String msg, Throwable t) {
        this.log(System.Logger.Level.WARNING, msg, t);
    }

    default public void warn(String msg, Throwable t, Object ... params) {
        this.log(System.Logger.Level.WARNING, msg, t, params);
    }

    default public void error(String msg, Object ... params) {
        this.log(System.Logger.Level.ERROR, msg, params);
    }

    default public void error(String msg, Throwable t) {
        this.log(System.Logger.Level.ERROR, msg, t);
    }

    default public void error(String msg, Throwable t, Object ... params) {
        this.log(System.Logger.Level.ERROR, msg, t, params);
    }

    default public void redirectSystemOut() {
        System.setOut(new LoggingPrintStream("STDOUT", this, System.Logger.Level.INFO));
    }

    default public void redirectSystemErr() {
        System.setErr(new LoggingPrintStream("STDERR", this, System.Logger.Level.ERROR));
    }
}

