/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.logger;

import io.gitlab.jfronny.commons.logger.CompactLogger;
import io.gitlab.jfronny.commons.logger.OutputColors;
import java.io.PrintStream;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrintStreamLogger
implements CompactLogger {
    @Nullable
    private final String name;
    private final boolean color;
    private final boolean thread;
    private final boolean timestamp;
    private final System.Logger.Level level;
    private final PrintStream target;

    public PrintStreamLogger(@NotNull PrintStream target, @Nullable String name, System.Logger.Level level, boolean color, boolean thread, boolean timestamp) {
        this.target = Objects.requireNonNull(target);
        this.name = name;
        this.level = level;
        this.color = color;
        this.thread = thread;
        this.timestamp = timestamp;
    }

    @Override
    public String getName() {
        return this.name == null ? "" : this.name;
    }

    @Override
    public System.Logger.Level getLevel() {
        return this.level;
    }

    @Override
    public void log(System.Logger.Level level, String message) {
        if (!this.isLoggable(level)) {
            return;
        }
        if (level == System.Logger.Level.ALL) {
            level = System.Logger.Level.TRACE;
        }
        this.target.println(this.generateMessage(message, level));
    }

    @Override
    public void log(System.Logger.Level level, String message, Throwable throwable) {
        if (!this.isLoggable(level)) {
            return;
        }
        if (level == System.Logger.Level.ALL) {
            level = System.Logger.Level.TRACE;
        }
        this.target.println(this.generateMessage(message, level));
        throwable.printStackTrace(this.target);
    }

    protected String generateMessage(String msg, System.Logger.Level level) {
        StringBuilder sb = new StringBuilder();
        if (this.timestamp) {
            sb.append(DateTimeFormatter.ofPattern("HH:mm:ss.SSS").format(LocalTime.now())).append(' ');
        }
        if (this.thread) {
            String thread = Thread.currentThread().getName();
            if (this.color) {
                sb.append("\u001b[1;36m").append(thread).append("\u001b[0m").append(' ');
            } else {
                sb.append('{').append(thread).append("} ");
            }
        }
        if (this.name != null) {
            if (this.color) {
                sb.append("\u001b[1;32m").append(this.name).append("\u001b[0m").append(' ');
            } else {
                sb.append('(').append(this.name).append(") ");
            }
        }
        if (this.color) {
            sb.append(OutputColors.byLevel(level)).append(level.name()).append("\u001b[0m").append(' ');
        } else {
            sb.append(level.name().charAt(0)).append(' ');
        }
        sb.append(msg);
        return sb.toString();
    }
}

