/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.logger;

import io.gitlab.jfronny.commons.StringFormatter;
import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import io.gitlab.jfronny.commons.logger.impl.Formatter;
import java.util.ResourceBundle;

public interface CompactLogger
extends SystemLoggerPlus {
    public System.Logger.Level getLevel();

    @Override
    public void log(System.Logger.Level var1, String var2);

    @Override
    default public void log(System.Logger.Level level, String message, Throwable throwable) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.log(level, message + System.lineSeparator() + StringFormatter.toString(throwable));
    }

    @Override
    default public boolean isLoggable(System.Logger.Level level) {
        if (level == System.Logger.Level.ALL) {
            return true;
        }
        if (level == System.Logger.Level.OFF) {
            return false;
        }
        return level.getSeverity() >= this.getLevel().getSeverity();
    }

    @Override
    default public void log(System.Logger.Level level, ResourceBundle resourceBundle, String s, Throwable throwable) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.log(level, Formatter.getResourceStringOrMessage(resourceBundle, s), throwable);
    }

    @Override
    default public void log(System.Logger.Level level, ResourceBundle resourceBundle, String s, Object ... objects) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.log(level, Formatter.format(resourceBundle, s, objects));
    }

    @Override
    default public void log(System.Logger.Level level, ResourceBundle bundle, String format, Throwable t, Object ... params) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.log(level, Formatter.format(bundle, format, params), t);
    }
}

