/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.io;

import io.gitlab.jfronny.commons.Serializer;
import io.gitlab.jfronny.commons.io.MultiAccessFileSystem;
import io.gitlab.jfronny.commons.throwable.ThrowingConsumer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class JFiles {
    private static final Map<Path, MultiAccessFileSystem> zipFsCache = new HashMap<Path, MultiAccessFileSystem>();

    public static void clearDirectory(Path directory) throws IOException {
        JFiles.clearDirectory(directory, p -> true);
    }

    public static void clearDirectory(Path directory, Predicate<Path> shouldDelete) throws IOException {
        if (!Files.exists(directory, new LinkOption[0])) {
            return;
        }
        try {
            JFiles.listTo(directory, p -> {
                if (Files.isDirectory(p, new LinkOption[0])) {
                    try {
                        if (!shouldDelete.test((Path)p)) return;
                        JFiles.deleteRecursive(p, shouldDelete);
                        return;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    if (!shouldDelete.test((Path)p)) return;
                    Files.delete(p);
                    return;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Throwable t) {
            throw new IOException("Could not clear directory", t);
        }
    }

    public static void deleteRecursive(Path path) throws IOException {
        JFiles.deleteRecursive(path, p -> true);
    }

    public static void deleteRecursive(Path path, final Predicate<Path> shouldDelete) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    FileVisitResult fv = super.visitFile(file, attrs);
                    if (fv != FileVisitResult.CONTINUE) {
                        return fv;
                    }
                    if (shouldDelete.test(file)) {
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    FileVisitResult fv = super.postVisitDirectory(dir, exc);
                    if (fv != FileVisitResult.CONTINUE) {
                        return fv;
                    }
                    if (shouldDelete.test(dir) && JFiles.list(dir).isEmpty()) {
                        Files.delete(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            Files.delete(path);
        }
    }

    public static void copyRecursive(Path source, Path destination) throws IOException {
        JFiles.copyRecursive(source, destination, StandardCopyOption.COPY_ATTRIBUTES);
    }

    public static void copyRecursive(Path source, Path destination, CopyOption ... copyOptions) throws IOException {
        boolean replaceExisting = Arrays.asList(copyOptions).contains(StandardCopyOption.REPLACE_EXISTING);
        if (Files.isDirectory(source, new LinkOption[0])) {
            Files.createDirectories(destination, new FileAttribute[0]);
            JFiles.listTo(source, sourceResolved -> {
                Path targetResolved = destination.resolve(sourceResolved.getFileName().toString());
                if (Files.exists(destination, new LinkOption[0])) {
                    if (!replaceExisting) {
                        return;
                    }
                    if (!Files.isDirectory(sourceResolved, new LinkOption[0])) {
                        Files.delete(destination);
                    }
                }
                JFiles.copyRecursive(sourceResolved, targetResolved, copyOptions);
            });
        } else if (Files.exists(source, new LinkOption[0])) {
            if (destination.getParent() != null) {
                Files.createDirectories(destination.getParent(), new FileAttribute[0]);
            }
            if (!Files.exists(destination, new LinkOption[0]) || replaceExisting) {
                Files.copy(source, destination, copyOptions);
            }
        } else {
            throw new FileNotFoundException(source.toString());
        }
    }

    public static List<Path> list(Path directory) throws IOException {
        try (Stream<Path> sp = Files.list(directory);){
            List<Path> list = sp.toList();
            return list;
        }
    }

    public static List<Path> list(Path directory, Predicate<Path> entryPredicate) throws IOException {
        try (Stream<Path> sp = Files.list(directory);){
            List<Path> list;
            block12: {
                Stream<Path> fi = sp.filter(entryPredicate);
                try {
                    list = fi.toList();
                    if (fi == null) break block12;
                }
                catch (Throwable throwable) {
                    if (fi != null) {
                        try {
                            fi.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fi.close();
            }
            return list;
        }
    }

    public static String[] listNames(Path directory) throws IOException {
        try (Stream<Path> sp = Files.list(directory);){
            String[] stringArray = (String[])sp.map(p -> Files.isDirectory(p, new LinkOption[0]) ? p.getFileName().toString() + "/" : p.getFileName().toString()).toArray(String[]::new);
            return stringArray;
        }
    }

    public static <TEx extends Exception> void listTo(Path directory, ThrowingConsumer<Path, TEx> consumer) throws IOException, TEx {
        try (Stream<Path> sp = Files.list(directory);){
            for (Path path : sp.toList()) {
                consumer.accept(path);
            }
        }
    }

    public static <T> T readObject(Path file, Type type) throws IOException {
        try (BufferedReader br = Files.newBufferedReader(file);){
            Object t = Serializer.getInstance().deserialize((Reader)br, type);
            return t;
        }
    }

    public static <T> T readObject(Path file, Class<T> type) throws IOException {
        try (BufferedReader br = Files.newBufferedReader(file);){
            T t = Serializer.getInstance().deserialize((Reader)br, type);
            return t;
        }
    }

    public static void writeObject(Path file, Object object) throws IOException {
        try (BufferedWriter bw = Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            Serializer.getInstance().serialize(object, bw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileSystem openZipFile(Path zip, boolean create, @Nullable ClassLoader classLoader) throws IOException, URISyntaxException {
        Map<Path, MultiAccessFileSystem> map = zipFsCache;
        synchronized (map) {
            if (!zipFsCache.containsKey(zip) || zipFsCache.get(zip).isClosed()) {
                URI fileUri = zip.toUri();
                zipFsCache.put(zip, MultiAccessFileSystem.create(new URI("jar:" + fileUri.getScheme(), fileUri.getPath(), null), create ? Map.of("create", "true") : Map.of(), classLoader));
            }
            return zipFsCache.get(zip).createLens();
        }
    }
}

