/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.io;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;

public class HashUtils {
    public static String sha1(byte[] data) {
        Formatter formatter = new Formatter();
        try {
            for (byte b : MessageDigest.getInstance("SHA-1").digest(data)) {
                formatter.format("%02x", b);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not hash using SHA1", e);
        }
        return formatter.toString();
    }

    public static String sha256(byte[] data) {
        Formatter formatter = new Formatter();
        try {
            for (byte b : MessageDigest.getInstance("SHA-256").digest(data)) {
                formatter.format("%02x", b);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not hash using SHA256", e);
        }
        return formatter.toString();
    }

    public static String sha512(byte[] data) {
        Formatter formatter = new Formatter();
        try {
            for (byte b : MessageDigest.getInstance("SHA-512").digest(data)) {
                formatter.format("%02x", b);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not hash using SHA512", e);
        }
        return formatter.toString();
    }

    public static long murmur2(byte[] data) {
        char b;
        int m = 1540483477;
        int r = 24;
        long k = 0L;
        int seed = 1;
        int shift = 0;
        long length = 0L;
        for (byte datum : data) {
            b = (char)datum;
            if (b == '\t' || b == '\n' || b == '\r' || b == ' ') continue;
            ++length;
        }
        long h = (long)seed ^ length;
        for (byte datum : data) {
            b = (char)datum;
            if (b == '\t' || b == '\n' || b == '\r' || b == ' ') continue;
            if (b > '\u00ff') {
                while (b > '\u00ff') {
                    b = (char)(b - 255);
                }
            }
            k |= (long)b << shift;
            if ((shift += 8) != 32) continue;
            h = 0xFFFFFFFFL & h;
            k *= 1540483477L;
            k = 0xFFFFFFFFL & k;
            k ^= k >> 24;
            k = 0xFFFFFFFFL & k;
            k *= 1540483477L;
            k = 0xFFFFFFFFL & k;
            h *= 1540483477L;
            h = 0xFFFFFFFFL & h;
            h ^= k;
            h = 0xFFFFFFFFL & h;
            k = 0L;
            shift = 0;
        }
        if (shift > 0) {
            h ^= k;
            h = 0xFFFFFFFFL & h;
            h *= 1540483477L;
            h = 0xFFFFFFFFL & h;
        }
        h ^= h >> 13;
        h = 0xFFFFFFFFL & h;
        h *= 1540483477L;
        h = 0xFFFFFFFFL & h;
        h ^= h >> 15;
        h = 0xFFFFFFFFL & h;
        return h;
    }
}

