/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.http.client;

import io.gitlab.jfronny.commons.Serializer;
import io.gitlab.jfronny.commons.data.Either;
import io.gitlab.jfronny.commons.http.client.HttpClient;
import io.gitlab.jfronny.commons.http.client.Method;
import io.gitlab.jfronny.commons.http.client.ReaderHandler;
import io.gitlab.jfronny.commons.http.client.ResponseHandlingMode;
import io.gitlab.jfronny.commons.http.client.SerializedHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class RequestBuilder {
    private static final Predicate<String> CURSEFORGE_API = Pattern.compile("(?:http(s)?://)?addons-ecs\\.forgesvc\\.net/api/+").asMatchPredicate();
    private final String url;
    private final HttpRequest.Builder builder;
    private Method method;
    private String accept;
    private int sent = 0;
    private int retryAfterDefault = 5000;
    private int retryAfterMax = 15000;
    private int retryLimit = 3;
    private boolean force11 = false;
    private ResponseHandlingMode responseHandlingMode = ResponseHandlingMode.HANDLE_ALL;
    private List<Exception> retryExceptions = null;

    protected RequestBuilder(Method method, String url) throws URISyntaxException {
        this.url = url.replace(" ", "%20");
        this.builder = HttpRequest.newBuilder().uri(new URI(this.url));
        this.method = method;
        this.userAgent(HttpClient.userAgent);
    }

    public RequestBuilder bearer(String token) {
        this.builder.header("Authorization", "Bearer " + token);
        return this;
    }

    public RequestBuilder header(String name, String value) {
        this.builder.header(name, value);
        return this;
    }

    public RequestBuilder setHeader(String name, String value) {
        this.builder.setHeader(name, value);
        return this;
    }

    public RequestBuilder timeout(Duration duration) {
        this.builder.timeout(duration);
        return this;
    }

    public RequestBuilder ignoreAll() {
        this.responseHandlingMode = ResponseHandlingMode.IGNORE_ALL;
        return this;
    }

    public RequestBuilder handleRedirects() {
        this.responseHandlingMode = ResponseHandlingMode.HANDLE_REDIRECTS;
        return this;
    }

    public RequestBuilder configureRetryAfter(int defaultDelay, int maxDelay) {
        if (defaultDelay < 1) {
            throw new IllegalArgumentException("defaultDelay must be greater than zero");
        }
        if (maxDelay < defaultDelay) {
            throw new IllegalArgumentException("maxDelay must be greater than or equal to defaultDelay");
        }
        this.retryAfterDefault = defaultDelay;
        this.retryAfterMax = maxDelay;
        return this;
    }

    public RequestBuilder setRetryLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit must be greater than or zero");
        }
        this.retryLimit = limit;
        return this;
    }

    public RequestBuilder accept(String value) {
        this.accept = value;
        return this;
    }

    public RequestBuilder userAgent(String value) {
        return this.setHeader("User-Agent", value);
    }

    public RequestBuilder forceHttp11() {
        this.force11 = true;
        return this;
    }

    public RequestBuilder bodyString(String string) {
        this.builder.header("Content-Type", "text/plain");
        this.builder.method(this.method.name(), HttpRequest.BodyPublishers.ofString(string));
        this.method = null;
        return this;
    }

    public RequestBuilder bodyForm(String string) {
        this.builder.header("Content-Type", "application/x-www-form-urlencoded");
        this.builder.method(this.method.name(), HttpRequest.BodyPublishers.ofString(string));
        this.method = null;
        return this;
    }

    public RequestBuilder bodyForm(Map<String, String> entries) {
        return this.bodyForm(entries.entrySet().stream().map(entry -> URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&")));
    }

    public RequestBuilder bodyJson(String string) {
        this.builder.header("Content-Type", "application/json");
        this.builder.method(this.method.name(), HttpRequest.BodyPublishers.ofString(string));
        this.method = null;
        return this;
    }

    public RequestBuilder bodySerialized(Object object) throws IOException {
        Serializer serializer = Serializer.getInstance();
        this.builder.header("Content-Type", serializer.getFormatMime());
        this.builder.method(this.method.name(), HttpRequest.BodyPublishers.ofString(serializer.serialize(object)));
        this.method = null;
        return this;
    }

    private <T> HttpResponse<T> _sendResponse(@Nullable String accept, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException {
        HttpResponse<T> res;
        ++this.sent;
        if (this.sent > this.retryLimit) {
            IOException e = new IOException("Attempted to reconnect/redirect " + this.sent + " times, which is more than the permitted " + this.retryLimit + ". Stopping");
            if (this.retryExceptions != null) {
                for (Exception ex : this.retryExceptions) {
                    e.addSuppressed(ex);
                }
            }
            throw e;
        }
        if (this.accept != null) {
            this.builder.header("Accept", this.accept);
        } else if (accept != null) {
            this.builder.header("Accept", accept);
        }
        if (this.method != null) {
            this.builder.method(this.method.name(), HttpRequest.BodyPublishers.noBody());
        }
        if (HttpClient.PROXY_AUTH != null) {
            this.builder.header("Proxy-Authorization", HttpClient.PROXY_AUTH);
        }
        try {
            res = (this.force11 ? HttpClient.CLIENT11 : HttpClient.CLIENT).send(this.builder.build(), responseBodyHandler);
        }
        catch (InterruptedException e) {
            throw new IOException("Could not send request", e);
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message != null && message.contains("GOAWAY received")) {
                return this.handleRetryAfter(accept, responseBodyHandler, this.retryAfterDefault);
            }
            throw new IOException("Could not send request", e);
        }
        if (res.statusCode() == 429 && (res.uri().getHost() + res.uri().getPath()).equals("www.google.com/sorry/index")) {
            throw new IOException("Google detected the request as a bot and blocked it. Please try again later.");
        }
        if (this.responseHandlingMode == ResponseHandlingMode.IGNORE_ALL) {
            return res;
        }
        if (res.statusCode() / 100 == 2) {
            return res;
        }
        Optional<String> location = res.headers().firstValue("location");
        Optional<Integer> retryAfter = res.headers().firstValue("Retry-After").flatMap(s -> {
            try {
                return Optional.of(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        });
        String exceptionSuffix = " (URL=" + this.url + ")";
        return switch (res.statusCode()) {
            case 429 -> {
                HttpResponse<T> var7_13 = this.handleRetryAfter(accept, responseBodyHandler, retryAfter.map(s -> s * 1000).orElse(this.retryAfterDefault));
                yield var7_13;
            }
            case 302, 307 -> {
                if (location.isPresent() && this.method == Method.GET) {
                    try {
                        RequestBuilder rb = HttpClient.get(location.get());
                        if (this.force11) {
                            rb.forceHttp11();
                        }
                        HttpResponse<T> var7_14 = rb._sendResponse(accept, responseBodyHandler);
                        yield var7_14;
                    }
                    catch (URISyntaxException e) {
                        throw new IOException("Could not follow redirect" + exceptionSuffix, e);
                    }
                }
                if (this.responseHandlingMode == ResponseHandlingMode.HANDLE_REDIRECTS) {
                    HttpResponse<T> var7_15;
                    yield var7_15 = res;
                }
                throw new IOException("Unexpected redirect: " + res.statusCode() + exceptionSuffix);
            }
            case 500, 502, 503, 504, 507 -> {
                if (this.responseHandlingMode == ResponseHandlingMode.HANDLE_REDIRECTS) {
                    HttpResponse<T> var7_16;
                    yield var7_16 = res;
                }
                if (CURSEFORGE_API.test(this.url)) {
                    HttpResponse<T> var7_17 = this.handleRetryAfter(accept, responseBodyHandler, Math.min(1000, this.retryAfterMax));
                    yield var7_17;
                }
                throw new IOException("Unexpected serverside error: " + res.statusCode() + exceptionSuffix);
            }
            case 404 -> {
                if (this.responseHandlingMode == ResponseHandlingMode.HANDLE_REDIRECTS) {
                    HttpResponse<T> var7_18;
                    yield var7_18 = res;
                }
                throw new FileNotFoundException("Didn't find anything under that url" + exceptionSuffix);
            }
            default -> {
                if (this.responseHandlingMode == ResponseHandlingMode.HANDLE_REDIRECTS) {
                    HttpResponse<T> var7_19;
                    yield var7_19 = res;
                }
                throw new IOException("Unexpected return method: " + res.statusCode() + exceptionSuffix);
            }
        };
    }

    private <T> HttpResponse<T> handleRetryAfter(@Nullable String accept, HttpResponse.BodyHandler<T> responseBodyHandler, int millis) throws IOException {
        if (millis > this.retryAfterMax) {
            throw new HttpTimeoutException("Wait time specified by Retry-After is too long: " + millis);
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new IOException("Could not sleep before resending request" + String.valueOf(e));
        }
        return this._sendResponse(accept, responseBodyHandler);
    }

    private <T> T unwrap(HttpResponse<T> response) throws IOException {
        return response.body();
    }

    public void send() throws IOException {
        this.unwrap(this.sendResponse());
    }

    public HttpResponse<Void> sendResponse() throws IOException {
        return this._sendResponse(null, HttpResponse.BodyHandlers.discarding());
    }

    public InputStream sendInputStream() throws IOException {
        return this.unwrap(this.sendInputStreamResponse());
    }

    public HttpResponse<InputStream> sendInputStreamResponse() throws IOException {
        return this._sendResponse(null, HttpResponse.BodyHandlers.ofInputStream());
    }

    public Reader sendReader() throws IOException {
        return this.unwrap(this.sendReaderResponse());
    }

    public HttpResponse<Reader> sendReaderResponse() throws IOException {
        return this._sendResponse(null, ReaderHandler.of());
    }

    public String sendString() throws IOException {
        return this.unwrap(this.sendStringResponse());
    }

    public HttpResponse<String> sendStringResponse() throws IOException {
        return this._sendResponse(null, HttpResponse.BodyHandlers.ofString());
    }

    public Stream<String> sendLines() throws IOException {
        return this.unwrap(this.sendLinesResponse());
    }

    public HttpResponse<Stream<String>> sendLinesResponse() throws IOException {
        return this._sendResponse(null, HttpResponse.BodyHandlers.ofLines());
    }

    public <T> T sendSerialized(Type type) throws IOException {
        Either<T, IOException> tmp = this.unwrap(this.sendSerializedResponse(type));
        if (tmp == null) {
            return null;
        }
        if (tmp.isLeft()) {
            return tmp.left();
        }
        throw new IOException("Could not deserialize", tmp.right());
    }

    public <T> HttpResponse<Either<T, IOException>> sendSerializedResponse(Type type) throws IOException {
        Serializer serializer = Objects.requireNonNull(Serializer.getInstance());
        return this._sendResponse(serializer.getFormatMime(), SerializedHandler.of(serializer, type));
    }
}

