/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.data.impl.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public abstract class LazyIterator<T>
implements Iterator<T> {
    T next = null;
    State state = State.NOT_READY;

    public static <T> Iterable<T> iterable(Supplier<LazyIteratorFn<T>> supplier) {
        return () -> LazyIterator.of((LazyIteratorFn)supplier.get());
    }

    public static <T> LazyIterator<T> of(final LazyIteratorFn<T> supplier) {
        return new LazyIterator<T>(){

            @Override
            protected T computeNext() {
                return supplier.computeNext(this::endOfData);
            }
        };
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Iterator.remove() is not supported");
    }

    @Override
    public final boolean hasNext() {
        if (this.state == State.FAILED) {
            throw new IllegalStateException("This iterator is in an inconsistent state, and can no longer be used, due to an exception previously thrown by the computeNext() method");
        }
        return switch (this.state.ordinal()) {
            case 2 -> false;
            case 0 -> true;
            default -> this.tryToComputeNext();
        };
    }

    boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        return this.next;
    }

    protected final T endOfData() {
        this.state = State.DONE;
        return null;
    }

    protected abstract T computeNext();

    static enum State {
        READY,
        NOT_READY,
        DONE,
        FAILED;

    }

    public static interface LazyIteratorFn<T> {
        public T computeNext(Scope<T> var1);
    }

    public static interface Scope<T> {
        public T endOfData();
    }
}

