/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.data;

import io.gitlab.jfronny.commons.data.immutable.ImmutableCollection;
import io.gitlab.jfronny.commons.data.immutable.ImmutableIterable;
import io.gitlab.jfronny.commons.data.immutable.ImmutableIterator;
import io.gitlab.jfronny.commons.data.immutable.ImmutableList;
import io.gitlab.jfronny.commons.data.immutable.ImmutableListIterator;
import io.gitlab.jfronny.commons.data.immutable.ImmutableMap;
import io.gitlab.jfronny.commons.data.immutable.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class ImmCollection {
    public static <T> Collection<T> of(Collection<T> collection) {
        return new ImmutableCollection(collection);
    }

    public static <T> List<T> of(List<T> list) {
        return new ImmutableList(list);
    }

    public static <T> List<T> copyOf(List<T> list) {
        return ImmCollection.of(new ArrayList<T>(list));
    }

    public static <T> Set<T> of(Set<T> set) {
        return new ImmutableSet(set);
    }

    public static <T> Set<T> copyOf(Set<T> set) {
        return ImmCollection.of(new LinkedHashSet<T>(set));
    }

    public static <K, V> Map<K, V> of(Map<K, V> map) {
        return new ImmutableMap<K, V>(map);
    }

    public static <K, V> Map<K, V> copyOf(Map<K, V> map) {
        return ImmCollection.of(new LinkedHashMap<K, V>(map));
    }

    public static <T> Iterable<T> of(Iterable<T> iterable) {
        return new ImmutableIterable(iterable);
    }

    public static <T> Iterator<T> of(Iterator<T> iterator) {
        return new ImmutableIterator(iterator);
    }

    public static <T> ListIterator<T> of(ListIterator<T> listIterator) {
        return new ImmutableListIterator(listIterator);
    }
}

