/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.data;

import java.util.function.Consumer;
import java.util.function.Function;

public final class Either<T1, T2> {
    private final Object value;
    private final boolean isLeft;

    public static <T1, T2> Either<T1, T2> left(T1 value) {
        return new Either<T1, T2>(value, true);
    }

    public static <T1, T2> Either<T1, T2> right(T2 value) {
        return new Either<T1, T2>(value, false);
    }

    private Either(Object value, boolean isLeft) {
        this.value = value;
        this.isLeft = isLeft;
    }

    public boolean isLeft() {
        return this.isLeft;
    }

    public boolean isRight() {
        return !this.isLeft;
    }

    public T1 left() {
        if (!this.isLeft) {
            throw new IllegalStateException("This Either does not represent a left value");
        }
        return (T1)this.value;
    }

    public T2 right() {
        if (this.isLeft) {
            throw new IllegalStateException("This Either does not represent a right value");
        }
        return (T2)this.value;
    }

    public void apply(Consumer<? super T1> lFunc, Consumer<? super T2> rFunc) {
        if (this.isLeft) {
            Either.relax(lFunc).accept(this.value);
        } else {
            Either.relax(rFunc).accept(this.value);
        }
    }

    public <T3> T3 fold(Function<? super T1, ? extends T3> lFunc, Function<? super T2, ? extends T3> rFunc) {
        return this.isLeft ? Either.relax(lFunc).apply(this.value) : Either.relax(rFunc).apply(this.value);
    }

    public <T3> Either<T3, T2> mapLeft(Function<? super T1, ? extends T3> func) {
        return this.isLeft ? Either.left(Either.relax(func).apply(this.value)) : Either.right(this.value);
    }

    public <T3> Either<T1, T3> mapRight(Function<? super T2, ? extends T3> func) {
        return this.isLeft ? Either.left(this.value) : Either.right(Either.relax(func).apply(this.value));
    }

    private static Consumer<Object> relax(Consumer<?> func) {
        return func;
    }

    private static <T> Function<Object, T> relax(Function<?, T> func) {
        return func;
    }
}

