/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.concurrent.scoped;

import io.gitlab.jfronny.commons.concurrent.scoped.IScopedValue;
import java.util.Deque;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public class ThreadLocalScopedValue<T>
implements IScopedValue<T> {
    private final InheritableThreadLocal<Carrier<T>> value = new InheritableThreadLocal<Carrier<T>>(this){

        @Override
        protected Carrier<T> childValue(Carrier<T> parentValue) {
            return new Carrier(parentValue);
        }

        @Override
        protected Carrier<T> initialValue() {
            return new Carrier();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R callWith(T value, Callable<? extends R> op) throws Exception {
        ((Carrier)this.value.get()).setValue(value);
        try {
            R r = op.call();
            return r;
        }
        finally {
            ((Carrier)this.value.get()).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R getWith(T value, Supplier<? extends R> op) {
        ((Carrier)this.value.get()).setValue(value);
        try {
            R r = op.get();
            return r;
        }
        finally {
            ((Carrier)this.value.get()).clear();
        }
    }

    @Override
    public void runWith(T value, Runnable op) {
        ((Carrier)this.value.get()).setValue(value);
        try {
            op.run();
        }
        finally {
            ((Carrier)this.value.get()).clear();
        }
    }

    @Override
    public T get() throws NoSuchElementException {
        return ((Carrier)this.value.get()).getValue();
    }

    @Override
    public Optional<T> getOptional() {
        return ((Carrier)this.value.get()).getOptional();
    }

    @Override
    public boolean isBound() {
        return ((Carrier)this.value.get()).isPresent();
    }

    @Override
    public T orElse(T other) {
        return ((Carrier)this.value.get()).orElse(other);
    }

    @Override
    public T orElse(Supplier<? extends T> otherSupplier) {
        return ((Carrier)this.value.get()).orElse(otherSupplier);
    }

    @Override
    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return ((Carrier)this.value.get()).orElseThrow(exceptionSupplier);
    }

    private static class Carrier<T> {
        private final Deque<T> value = new LinkedList<T>();
        private final Carrier<T> parent;

        public Carrier() {
            this(null);
        }

        public Carrier(Carrier<T> parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Optional<T> valueIfPresent() {
            Deque<T> deque = this.value;
            synchronized (deque) {
                if (!this.value.isEmpty()) {
                    return Optional.of(this.value.peek());
                }
                return Optional.empty();
            }
        }

        public T getValue() {
            return (T)this.valueIfPresent().orElseGet(() -> {
                if (this.parent == null) {
                    throw new NoSuchElementException("No value present");
                }
                return this.parent.getValue();
            });
        }

        public boolean isPresent() {
            if (!this.value.isEmpty()) {
                return true;
            }
            if (this.parent == null) {
                return false;
            }
            return this.parent.isPresent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(T value) {
            Deque<T> deque = this.value;
            synchronized (deque) {
                this.value.push(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Deque<T> deque = this.value;
            synchronized (deque) {
                this.value.pop();
            }
        }

        public T orElse(T other) {
            return (T)this.valueIfPresent().orElseGet(() -> {
                if (this.parent == null) {
                    return other;
                }
                return this.parent.orElse(other);
            });
        }

        public T orElse(Supplier<? extends T> otherSupplier) {
            return (T)this.valueIfPresent().orElseGet(() -> {
                if (this.parent == null) {
                    return otherSupplier.get();
                }
                return this.parent.orElse(otherSupplier);
            });
        }

        public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
            Optional<T> v = this.valueIfPresent();
            if (v.isPresent()) {
                return v.get();
            }
            if (this.parent == null) {
                throw (Throwable)exceptionSupplier.get();
            }
            return this.parent.orElseThrow(exceptionSupplier);
        }

        public Optional<T> getOptional() {
            return this.valueIfPresent().or(() -> {
                if (this.parent == null) {
                    return Optional.empty();
                }
                return this.parent.getOptional();
            });
        }
    }
}

