/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.concurrent;

import io.gitlab.jfronny.commons.concurrent.scoped.IScopedValue;
import io.gitlab.jfronny.commons.concurrent.scoped.ThreadLocalScopedValue;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;

public class ScopedValue<T>
implements ThrowingSupplier<T, NoSuchElementException> {
    private final IScopedValue<T> delegate;

    private ScopedValue(IScopedValue<T> delegate) {
        this.delegate = delegate;
    }

    @Deprecated
    public ScopedValue() {
        this(new ThreadLocalScopedValue());
    }

    public static <T> ScopedValue<T> newInstance() {
        return new ScopedValue(new ThreadLocalScopedValue());
    }

    public static <T, R> R callWhere(ScopedValue<T> key, T value, Callable<? extends R> op) throws Exception {
        return key.delegate.callWith(value, op);
    }

    public static <T, R> R getWhere(ScopedValue<T> key, T value, Supplier<? extends R> op) {
        return key.delegate.getWith(value, op);
    }

    public static <T> void runWhere(ScopedValue<T> key, T value, Runnable op) {
        key.delegate.runWith(value, op);
    }

    public static Context.Builder context() {
        return new Context.Builder(){
            Context context = new Context(this){

                @Override
                public <R> R call(Callable<? extends R> op) throws Exception {
                    return op.call();
                }

                @Override
                public <R> R get(Supplier<? extends R> op) {
                    return op.get();
                }

                @Override
                public void run(Runnable op) {
                    op.run();
                }
            };

            @Override
            public <T> Context.Builder add(final ScopedValue<T> key, final T value) {
                final Context old = this.context;
                this.context = new Context(){

                    @Override
                    public void run(Runnable op) {
                        ScopedValue.runWhere(key, value, () -> old.run(op));
                    }

                    @Override
                    public <R> R get(Supplier<? extends R> op) {
                        return (R)ScopedValue.getWhere(key, value, () -> old.get(op));
                    }

                    @Override
                    public <R> R call(Callable<? extends R> op) throws Exception {
                        return (R)ScopedValue.callWhere(key, value, () -> old.call(op));
                    }
                };
                return this;
            }

            @Override
            public Context build() {
                return this.context;
            }
        };
    }

    @Override
    public T get() {
        return this.delegate.get();
    }

    public String toString() {
        return this.get().toString();
    }

    public Optional<T> getOptional() {
        return this.delegate.getOptional();
    }

    public boolean isBound() {
        return this.delegate.isBound();
    }

    public T orElse(T other) {
        return this.delegate.orElse(other);
    }

    public T orElse(Supplier<? extends T> otherSupplier) {
        return this.delegate.orElse(otherSupplier);
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return this.delegate.orElseThrow(exceptionSupplier);
    }

    public <R> ScopedValue<R> map(Function<? super T, ? extends R> mapper) {
        return new ScopedValue<R>(this.delegate.map(mapper));
    }

    public static interface Context {
        public <R> R call(Callable<? extends R> var1) throws Exception;

        public <R> R get(Supplier<? extends R> var1);

        public void run(Runnable var1);

        public static interface Builder {
            public <T> Builder add(ScopedValue<T> var1, T var2);

            public Context build();
        }
    }
}

